
NB. Created app def file is as follows

NB. ====================================================================================================
NB. ====  (1/4) name of application =======
NB./*/APP_FOLDER_NAME/51_barrier_option_pricing_model


NB. ====================================================================================================
NB. ====  (2/4) design of HTML doc  =======
NB./*/HTML_TITLE/Barrier Option
NB./*/HTML_REMARK/Barrier Option web form version. Select condition radiobutton and dropdwon, and edit textbox values as needed. Submit button calculate and save answer to a specified file unless no save button selected.

NB./*/HORIZONTALLINE
NB./*/This form is a web form version of Barrier Option Pricing Models by J. Takeuchi (JAPLA 2009 6 27)
NB./*/TEXTBOX/00/HORIZONTAL/10/_______Current Price /120
NB./*/TEXTBOX/01/HORIZONTAL/10/________Strike Price /100
NB./*/TEXTBOX/02/HORIZONTAL/10/_______Barrier Price /90
NB./*/TEXTBOX/03/VERTICAL/10/__TimeInYears(month) /6
NB./*/TEXTBOX/04/HORIZONTAL/10/__Volatility(%) year /30
NB./*/TEXTBOX/05/HORIZONTAL/10/InterestRate(%) year /5

NB./*/DROPDOWN/00/VERTICAL/________repeat_times /1000+0/10000+1/100000+2
NB./*/DROPDOWN/01/HORIZONTAL/____________time_span /OneWeek+0/ThreeDay+1/OneDay+2

NB./*/HORIZONTALLINE
NB./*/RADIOBUTTON/00/HORIZONTAL/_______Mode /Barrier+1000/Simulation+0100/BS+0010/bsMcdanel+0001
NB./*/NEWLINE
NB./*/RADIOBUTTON/01/HORIZONTAL/Call or Put /Call+10/Put+01
NB./*/NEWLINE
NB./*/RADIOBUTTON/02/HORIZONTAL/__Out or In /Out+10/In+01
NB./*/HORIZONTALLINE

NB./*/RADIOBUTTON/03/HORIZONTAL/file save option /New+100/Append+010/No save+001

NB./*/TEXTBOX/07/VERTICAL/20/directory for file save/
NB./*/TEXTBOX/06/VERTICAL/20/Filename for saving answer /answer_file.txt
NB./*/TEXTAREA/00/VERTICAL/100/6/Current Contents of answer file /


NB. ====================================================================================================
NB. ====  (3/4) descrition of J function  =======
NB.define your J function(s) which will be used in YOUR_JOB function

NB.load 'barrier_face2_new_jconsole.ijs'
NB. JAPLA研究会 2009年6月資料の付録
NB. バリアーオプションのＪ関数
require 'jfiles'
conew 'jfiles'

NB. Form for takeuchi barrier option
BARRIEROPTION=: 0 : 0
pc BarrierOption;
xywh 149 144 46 33;cc ok button;cn "Calc";
xywh 169 3 30 14;cc cancel button;cn "EXIT";
xywh 14 40 38 11;cc rb0 radiobutton;cn "Call";
xywh 55 40 35 11;cc rb1 radiobutton group;cn "Put";
xywh 9 35 81 19;cc radio01 groupbox;cn "Call/Put";
xywh 14 61 38 11;cc rb8 radiobutton;cn "Out";
xywh 55 61 35 11;cc rb9 radiobutton group;cn "In";
xywh 9 55 81 19;cc radio01 groupbox;cn "Out/In";
xywh 10 22 33 11;cc rb4 radiobutton;cn "Barrier";
xywh 42 21 43 11;cc rb5 radiobutton group;cn "Simulation";
xywh 133 20 22 11;cc rb6 radiobutton group;cn "BS";
xywh 155 20 45 11;cc rb7 radiobutton group;cn "bsMcdanell";
xywh 9 15 193 19;cc radio47 groupbox;cn "mode";
xywh 84 18 42 14;cc selsim button;cn "SelectMode";
xywh 3 91 60 12;cc ed0 edit;
xywh 70 91 60 12;cc ed1 edit;
xywh 135 91 60 12;cc ed2 edit;
xywh 5 125 60 14;cc ed3 edit;
xywh 70 126 60 12;cc ed4 edit;
xywh 135 126 60 12;cc ed5 edit;
xywh 94 45 60 99;cc combo0 combodrop ws_vscroll;
xywh 95 65 60 60;cc combo1 combodrop ws_vscroll;
xywh 92 34 107 45;cc sim groupbox;cn "SimulationOnly";
xywh 159 49 41 11;cc st6 static;cn "repeat times";
xywh 158 65 44 11;cc st7 static;cn "time span";
xywh 4 78 60 11;cc st0 static;
xywh 70 78 60 11;cc st1 static;
xywh 135 79 60 11;cc st2 static;
xywh 0 111 72 11;cc st3 static;
xywh 76 112 54 11;cc st4 static;
xywh 134 110 60 11;cc st5 static;
xywh 5 144 134 31;cc ans static rightmove bottomscale;
xywh 34 3 48 12;cc selek button;
xywh 3 187 35 12;cc ed6 edit;
xywh 4 172 75 11;cc files static;cn "filename(numberOnly)";
xywh 62 185 141 19;cc files groupbox;cn "FileSave";
xywh 70 190 41 11;cc rb8 radiobutton;cn "New/Reset";
xywh 115 191 32 11;cc rb9 radiobutton group;cn "Append";
xywh 155 191 38 12;cc wrifil button;cn "WRITE";
pas 6 6;pcenter;
rem form end;
)

BarrierOption_run=: 3 : 0
wd BARRIEROPTION
NB. initialize form here
set_file ''
ek_set_jp '' NB. start Kanji 
wd 'pshow;'
)

set_combo0=: 3 : 0
TIME0=. ": L:0 {@>1000 10000 100000 
wd 'set combo0 ',; TIME0 ,each LF
wd 'setselect combo0 0;'
)

set_combo1=: 3 : 0
TIME1=. ;:'OneWeek ThreeDay OneDay'
wd 'set combo1 ',;TIME1 , each LF
wd 'setselect combo1 0;'
)
init=: 3 : 0
'ed0 ed1 ed2 ed3 ed4 ed5'=:'120';'100';'90';'6';'30';'5'
)
disp_deprecated=: 3 : 0
wd 'set ed0 * ',ed0
wd 'set ed1 * ',ed1
wd 'set ed2 * ',ed2
wd 'set ed3 * ',ed3
wd 'set ed4 * ',ed4
wd 'set ed5 * ',ed5
)

BarrierOption_selsim_button=: 3 : 0
init ''
NB. disp_deprecated ''
SEL=: ". rb4,rb5,rb6,rb7
if. 100= SEL do. NB. select simulation
 set_combo0 ''
 set_combo1 ''
end.
if. (". rb6,rb7) e. 10 1 do. NB. push
 wd 'set ed2 * ','not using'
NB.  Cut *****  else. wd 'set ed2 * ',''
end.
)

BarrierOption_close=: 3 : 0
wd'pclose'
)

BarrierOption_cancel_button=: 3 : 0
BarrierOption_close''
)

BarrierOption_calc_jconsole =: 3 : 0
NB. check edit 
SEL0=: (".rb0),(".rb1) NB. 10/01 is Call/Put
SEL1=: (".rb2),(".rb3) NB. 10/01 is Out/In
SEL2=. ". rb4,rb5,rb6,rb7 NB. 1000 /100 is calc/simulation
NB. ----------------------------------
TIM0=: 1000 ] TIM1=: 60 NB. initial( if empty value)
TIM0=: (". combo0_select){ 1000 10000 100000 NB. repeat times
TIM1=: (". combo1_select){ 60 120 360 NB. time span(week 3dat 1day)
NB.  set X0
X0=:(+/SEL0*(1 2)),+/SEL1*(1 2)
NB. --mode select-----------------------
select. SEL2
 case. 1000 do. NB. Barrier
  Y0=. ".@> ed0;ed1;ed2;ed3;ed4;ed5
  ANS=: X0 Barrier_cal Y0
  ANS=: X0;Y0;ANS 
 case. 100  do. NB. simulation
  Y01=. ".@> ed0;ed1;ed2
  Y02=: (". combo1_select){ <. ((".ed3)*30) % 6 3 1  
NB. remain is cut(<.)
NB. autocalc /per 30*month % weak 3day 1day
   Y03=. ".@>ed4;ed5
   Y0=. Y01,Y02,Y03
   ANS=:(X0=: TIM0,TIM1,X0) Barrier_sym Y0
   ANS=: X0;Y0;ANS 
case.  10 do. NB. bs model
  Y0=. ".@> ed0;ed1;ed3;ed4;ed5
  ANS=: (".rb0) bs Y0 
  ANS=: 0;Y0;ANS
 case. 1 do. NB. bs McDanell
  Y01=: ".@> ed0;ed1;ed3;ed4;ed5
  NB. set same unit
    if. 1 0-: SEL0 do. Y0=.1 1 1r12 0.01 0.01 * 0 1 2 4 3 {Y01
     NB. Call
     else.  Y0=.1 1 1r12 0.01 _0.01 * 0 1 2 4 3 {Y01  end. 
     NB. put volatiliry is minus  
  ANS=: BS Y0
  ANS=: 0;Y0;ANS 
end. 
ANSEX=: ANS

NB. diaplay ANS on static boards
if.rb2='1' do. OutIn=:' Out = '
 else. OutIn=:' In = ' end.
NB.wd'setfont ans ',font
NB. wd'setcaption board *',btexth
if. rb0='1' do. ANSS=. 'CALL',OutIn ,": ; {: ANS
 else. ANSS=. 'PUT',OutIn,": ;{: ANS end.
NB. wd'set ans *',  ANSS
NB. ANSS is the answer to be displyed... so return this for reply_msg
print 'ANS =====> ', ":ANS
if. (; {: ANS) < 0 do.
    ANSS2 =. underbar_to_hifen_here ANSS
    ANSS =. ANSS2
end.
NB. ANSS2

ANSS
NB. -----append files----------------------------
)

underbar_to_hifen_here =: 3 : 0
'-' (y i. '_')}y
)


BarrierOption_ok_button=: 3 : 0
disp_deprecated ''
NB. check edit 
SEL0=: (".rb0),(".rb1) NB. 10/01 is Call/Put
SEL1=: (".rb8),(".rb9) NB. 10/01 is Out/In
SEL2=. ". rb4,rb5,rb6,rb7 NB. 1000 /100 is calc/simulation
NB. ----------------------------------
TIM0=: 1000 ] TIM1=: 60 NB. initial( if empty value)
TIM0=: (". combo0_select){ 1000 10000 100000 NB. repeat times
TIM1=: (". combo1_select){ 60 120 360 NB. time span(week 3dat 1day)
NB.  set X0
X0=:(+/SEL0*(1 2)),+/SEL1*(1 2)
NB. --mode select-----------------------
select. SEL2
 case. 1000 do. NB. Barrier
  Y0=. ".@> ed0;ed1;ed2;ed3;ed4;ed5
  ANS=: X0 Barrier_cal Y0
  ANS=: X0;Y0;ANS 
 case. 100  do. NB. simulation
  Y01=. ".@> ed0;ed1;ed2
  Y02=: (". combo1_select){ <. ((".ed3)*30) % 6 3 1  
NB. remain is cut(<.)
NB. autocalc /per 30*month % weak 3day 1day
   Y03=. ".@>ed4;ed5
   Y0=. Y01,Y02,Y03
   ANS=:(X0=: TIM0,TIM1,X0) Barrier_sym Y0
   ANS=: X0;Y0;ANS 
case.  10 do. NB. bs model
  Y0=. ".@> ed0;ed1;ed3;ed4;ed5
  ANS=: (".rb0) bs Y0 
  ANS=: 0;Y0;ANS
 case. 1 do. NB. bs McDanell
  Y01=: ".@> ed0;ed1;ed3;ed4;ed5
  NB. set same unit
    if. 1 0-: SEL0 do. Y0=.1 1 1r12 0.01 0.01 * 0 1 2 4 3 {Y01
     NB. Call
     else.  Y0=.1 1 1r12 0.01 _0.01 * 0 1 2 4 3 {Y01  end. 
     NB. put volatiliry is minus  
  ANS=: BS Y0
  ANS=: 0;Y0;ANS 
end. 
ANSEX=: ANS
NB. diaplay ANS on static boards
if.rb8='1' do. OutIn=:' Out ='
 else. OutIn=:' In =' end.
wd'setfont ans ',font
NB. wd'setcaption board *',btexth
if. rb0='1' do. ANSS=. 'CALL',OutIn ,": ; {: ANS
 else. ANSS=. 'PUT',OutIn,": ;{: ANS end.
wd'set ans *',  ANSS
NB. -----append files----------------------------

)

NB. ------ENGLISH_JAPAN---------
c_selek=: 'English'
c_st0=: 'スポット価格'
c_st1=: '行使価格'
c_st2=: 'バリア価格'
c_st3=: 'オプション期間（月）'
c_st4=: 'ボラティリティ(%）'
c_st5=: 'リスクフリー金利(%年）'

e_selek=: '漢字'
e_st0=: 'CurrentPrice'
e_st1=: 'StrikePrice'
e_st2=: 'BarrierPrice'
e_st3=: 'TimeInYears(Month)'
e_st4=: 'Volatility(%）year'
e_st5=: 'InterestRate(%）year'

set_font=: 3 : 0
)

ek_set_eng=: 3 : 0
NB. initial set
wd'setfont selek ',font
wd'setfont st0 ',font
wd'setfont st1 ',font
wd'setfont st2 ',font
wd'setfont st3 ',font
wd'setfont st4 ',font
wd'setfont st5 ',font
NB. -------------------
wd'setcaption selek *','漢字'  NB. button
wd'set st0 *',e_st0 NB. editm
wd'set st1 *',e_st1
wd'set st2 *',e_st2
wd'set st3 *',e_st3
wd'set st4 *',e_st4
wd'set st5 *',e_st5
btextCheck=: 1 NB.  display button [KANJI]
)

ek_set_jp=: 3 : 0
wd'setfont selek ',font
wd'setfont st0 ',font
wd'setfont st1 ',font
wd'setfont st2 ',font
wd'setfont st3 ',font
wd'setfont st4 ',font
wd'setfont st5 ',font
NB. -------------------
wd'setcaption selek *','ENGLISH'
wd'set st0 *',c_st0 NB. editm
wd'set st1 *',c_st1
wd'set st2 *',c_st2
wd'set st3 *',c_st3
wd'set st4 *',c_st4
wd'set st5 *',c_st5
btextCheck=: 0 NB.  display button [English]
)

BarrierOption_selek_button=: 3 : 0
select. btextCheck
  case. 0  do.  NB. push Kanji
    ek_set_eng ''
  case.  1 do.   NB. push English
    ek_set_jp ''
end.
)


NB. ------Files--------------------------
br=:BarrierOption_wrifil_button=: 3 : 0
NW_AP=: ". rb8,rb9
FNAME=. ": ". ed6
NB. ed6 is number(charactor)
if. 10= NW_AP  do. 
 NB. jerase 'temp/barrier',ed6,'ijf'
 jcreate jpath '~temp/barrier', FNAME 
 (<ANSEX) jappend  jpath '~temp/barrier', FNAME 
end.
if. 1=NW_AP do.  
 (<ANSEX) jappend jpath '~temp/barrier',FNAME 
end. 
)

set_file=: 3 : 0
wd 'set ed6 * ',": 0
)

NB. BarrierOption_run ''

NB. ==========================================
NB. Black Scholes Model
NB. M.Shimura  Nov. 2000
NB. ussage: x bs data   x...1 Call  x...2 Put
NB. data is list ( 5 block)
NB. 現在の株価 権利行使価格 オプションの期間(月）ボラティリティ（％） 非危険利子率（％）
NB. ex. data=. 14500 14000  2 38 6
NB. ==========================================
bs =: 4 : 0
if. x=1 do. sign=:1 else. sign=:-1 end.
'a b c d e'=. y
t=. c % 12
u=. (^. a % b) +  t* (e1=.e % 100) - -:(bor=.d % 100) ^2   
p2=. u % (bor * %: t)
p1=. p2 + bor * %: t
n1=.ndf sign * p1
n2=. ndf sign * p2
bs=. sign * (a * n1 ) -  b *n2 *( ^ (-e1) * t) 
bs 
)

NB. ************************************************
NB. Normal distribution
NB. Original script is written by G. Suzuki math p 81
NB. modifyed by M.Shimura 
NB. ***********************************************

 nd=:( % &( %: 2p1))&([: ^ [: - [: -: *:@])  NB. same as  ndens 

 ndfs2=: 3 : 0
(-: h * (nd 0)+ nd y )+ h * +/ nd ( >: i.249)* h =.| y % 250
)
   
ndf=: 0.5&+@(**ndfs2)

NB. ------BS by Eugine Macdnard--------
NB. S - the current price of the asset
NB. X - the strike price (price when option is to be exercised)
NB. T - the time in years
NB. r - the risk-free interest rate
NB.v - the volatility, typically the standard deviation of S 
NB. for the last 3 or 6 months

BS =: monad define
'S X T r v' =. y
-/(S,X*^-r*T)*N((^.S%X)+T*r(+,-)-:*:v)%v*%:T
)

erf=:(*&(%:4p_1) % ^@:*:) * [: 1 H. 1.5 *: NB. Ewart Shaw Vector 18.4
cnd =:N=: [: -: 1: + [: erf %&(%:2)   NB. CDF of N(0,1) 
NB. ===========================================================
NB. written by TAKEUCHI JUICHIRO
NB. original script is in JAPLA 04/2009 
NB. Normal Distribution
NB. mx֐  ̕̕z֐  㑤m֐@ݐϕz֐
NB. stnormal NP NQ Ndist
   stnormal=:(%:@o.@2:)(%~)^@-@-:@*:
   NP=:3 : 0
(stnormal y)*y%(-`%`+`%)/,(>:+:k),.(*:y)*>:k=.i.28
)
   NQ=:3 : 0
(stnormal y)*%`+/1,,y ,.>:i.28
)
   Ndist=:3 : 0
if. 3.3<z=:|y do. q=:NQ z else. q=:0.5-NP z end.
if. 0<:y do. q=:1-q end.
)
NB. Yamanouti's Formula  tK֐(Kz̃p[Zg_AŘ)
   Ninv_y=:3 : 0
z=.-^.4*y*(1-y)
x=.%:z*(2.0611786-5.7262204%(z+11.640595))
if. y>0.5 do. x=.-x end.
)
NB. Normal Random Numbers  K
NB.    Rndm_Norm Size Mu Sigma  gFRndm_Norm ̐  
   Rndm_Norm=:3 : 0
'Num Mean Sigma'=.y
Mean+Sigma*Ninv_y"0 (?Num#10000000)%10000000
NB.{.Ninv_bm"1 z=:(?(Num,2)$10000000)%10000000
)

NB. ȉoA[IvV̉i֐łB
NB. =========================================================
NB. Barrier Option Pricing Model
NB. J.Takeuchi Apr. 2009
NB. Usage: Opt Barrier_cal Data
NB. Opt and Data is vectors ( 2 and 6 factors)
NB. Opt=(1...Call 2...Put) , (1...NockOut 2...NockIn)  
NB. Data=SpotPrice StrPrice BarrierPrice Term(Month) Sigma FreeRate
NB. ex. Call Out=. 1 1   Data=. 120 90 100 6 30 5
NB. =========================================================
   Barrier_cal=:4 : 0
'Spot Kosi Barrier Term Sigma Rate'=. y
'Call Out'=: x
if. Call=2 do. fugo=:_1 else. fugo=:1 end.
if. Barrier>Spot do. score=:0 else. score=:2 end.
if. Barrier<Kosi do. score=:score else. score=:score+1 end.
if. Call=2 do. score=:3-score end.
Ter=:Term%12[Sig=:Sigma%100[Rat=:Rate%100
m=:(Barrier%Spot)^((2*Rat%Sig^2)-1)
er=.^-Rat*Ter
d1=.ddd Spot,Kosi
d2=.ddd Spot,Barrier
d3=.ddd (Barrier^2),Kosi*Spot
d4=.ddd Barrier,Spot
D1=:fugo*(Spot*Ndist(fugo*d1+Sig*%:Ter))-Kosi*er*Ndist(fugo*d1)
D2=:fugo*(Spot*Ndist(fugo*d2+Sig*%:Ter))-Kosi*er*Ndist(fugo*d2)
D3=:fugo*(((Barrier^2)%Spot)*Ndist(fugo*d3+Sig*%:Ter))-Kosi*er*Ndist(fugo*d3)
D4=:fugo*(((Barrier^2)%Spot)*Ndist(fugo*d4+Sig*%:Ter))-Kosi*er*Ndist(fugo*d4)
select. score
case. 0 do. D=:0
case. 1 do. D=:(D1-D2)-m*(D3-D4)
case. 2 do. D=:D1-m*D3
case. 3 do. D=:D2-m*D4
end.
if. Out=2 do. Hyoka=:(Call  bs (1 1 0 1 1 1#y))-D
else. Hyoka=:D
end.
)
NB.=============================================================
NB.ddd Numerator(Bunsi),Denominator(Bunbo)
NB.Usage : ddd Spot,Barrier
NB.=============================================================
   ddd=:3 : 0
'Nume Deno'=.y
((^.Nume%Deno)+(Rat--:*:Sig)*Ter)%Sig*%:Ter
)
NB.=============================================================
NB.Simulation for Barrier Option 
NB.Opt. Barrier_Sym Spot Kousi Barrier Term Volat Rate
NB.Opt.==>Numbers,(Call..1  Put..2),(Knock Out..1,Knock In..2),Int.
NB.Int==>Intervals:12..Month 54..Week  120..3days  365..1day
NB.=============================================================
   Barrier_sym=:4 : 0
'S0 K B T Vol r'=.y
i=.0[S=.MM#Smax=.Smin=.S0['MM Int Call Out'=.x
label_L1.
if. T<i=.>:i do. goto_owari. end.
z=.Rndm_Norm MM,0,1
S=.S+(S*(r%100)*(1%Int))+S*(Vol%100)*(%:1%Int)*z
Smin=.S<.Smin
Smax=.S>.Smax
NB. print S
goto_L1.
label_owari.
if. Call=1 do. w=.S-K else. w=.K-S end.
if. S0<B do. p=:Smax<B else. p=:Smin>B end.
if. Out=2 do. p=:-.p end.
ww=:w*p
NB. w=.(S-K)
C=.(^-(r%100)*(T%Int))*MM%~+/(0<ww)#ww
)
NB. ==========================================
NB. Plain Vannila Option Model(Black & Scholes)
NB. x bs a b c d e
NB. x:1...Call 2...Put a...Spot b...Strike
NB. c...Term(Month) d...Volatility e...Rate
NB. ===========================================
bs =: 4 : 0
'a b c d e'=. y
if.x=1 do. sign=:1 else. sign=:-1 end.
t=. c % 12
u=. (^. a % b) + t* (e1=.e % 100) - -:(vol=.d % 100) ^2
p2=. u % (vol * %: t)
p1=. p2 + vol * %: t
n1=. Ndist sign * p1
n2=. Ndist sign * p2
bs=. sign * (a * n1 ) - b *n2 *( ^ (-e1) * t)
bs
)


NB.
NB. ====================================================================================================
NB. ====  (4/4) desctiption of your job based on POSTed data as argument of J function =======
YOUR_JOB =: 3 : 0
a_collection =. monitor_entry_ID_values 0 NB.extraction of POSTed data
reply_msg =. 'operation done without error', CRLF, a_collection, CRLF

try. NB. -----
NB. contents of this textarea will be saved in try. block of YOUR_JOB function

Modes      =. RADIO_00_VALUE
CallPut    =. RADIO_01_VALUE
OutIn      =. RADIO_02_VALUE
SaveOption =. RADIO_03_VALUE

rb0 =: 0 { CallPut
rb1 =: 1 { CallPut

rb2 =: 0 { OutIn
rb3 =: 1 { OutIn

rb4 =: 0 { Modes
rb5 =: 1 { Modes
rb6 =: 2 { Modes
rb7 =: 3 { Modes

rb8 =. 0 { SaveOption
rb9 =. 1 { SaveOption
rba =. 2 { SaveOption

combo0_select =: DROPDOWN_00_VALUE
combo1_select =: DROPDOWN_01_VALUE

ed0 =: TEXTBOX_00_VALUE
ed1 =: TEXTBOX_01_VALUE
ed2 =: TEXTBOX_02_VALUE
ed3 =: TEXTBOX_03_VALUE
ed4 =: TEXTBOX_04_VALUE
ed5 =: TEXTBOX_05_VALUE

ed6 =: TEXTBOX_06_VALUE
TEXTBOX_07_VALUE =: INSTALL_DIR, '/usr'
NB. this is usr file directory for wtf_usr, rff_usr

print 'rb0 ', rb0
print 'rb1 ', rb1
print 'rb2 ', rb2
print 'rb3 ', rb3
print 'rb4 ', rb4
print 'rb5 ', rb5
print 'rb6 ', rb6
print 'rb7 ', rb7
print 'rb8 ', rb8
print 'rb9 ', rb9
print 'rba ', rba

print 'comb0_select ', combo0_select
print 'comb1_select ', combo1_select

print 'ed0 ', ed0
print 'ed1 ', ed1
print 'ed2 ', ed2
print 'ed3 ', ed3
print 'ed4 ', ed4
print 'ed5 ', ed5
print 'ed6 ', ed6

reply_msg =. reply_msg, CRLF, 'rb0 ', rb0
reply_msg =. reply_msg, CRLF, 'rb1 ', rb1
reply_msg =. reply_msg, CRLF, 'rb2 ', rb2
reply_msg =. reply_msg, CRLF, 'rb3 ', rb3
reply_msg =. reply_msg, CRLF, 'rb4 ', rb4
reply_msg =. reply_msg, CRLF, 'rb5 ', rb5
reply_msg =. reply_msg, CRLF, 'rb6 ', rb6
reply_msg =. reply_msg, CRLF, 'rb7 ', rb7
reply_msg =. reply_msg, CRLF, 'rb8 ', rb8
reply_msg =. reply_msg, CRLF, 'rb9 ', rb9
reply_msg =. reply_msg, CRLF, 'rba ', rba

reply_msg =. reply_msg, CRLF, 'comb0_select ', combo0_select
reply_msg =. reply_msg, CRLF, 'comb1_select ', combo1_select

reply_msg =. reply_msg, CRLF, 'ed0 ', ed0
reply_msg =. reply_msg, CRLF, 'ed1 ', ed1
reply_msg =. reply_msg, CRLF, 'ed2 ', ed2
reply_msg =. reply_msg, CRLF, 'ed3 ', ed3
reply_msg =. reply_msg, CRLF, 'ed4 ', ed4
reply_msg =. reply_msg, CRLF, 'ed5 ', ed5
reply_msg =. reply_msg, CRLF, 'ed6 ', ed6

barrier_option_calculation_answer =. BarrierOption_calc_jconsole 0
ANSWER_DATA =: barrier_option_calculation_answer
reply_msg =. reply_msg,CRLF, CRLF, barrier_option_calculation_answer

ANSEX_in_text =. (": ;ANSEX), CRLF, ANSWER_DATA, CRLF, CRLF

if. (; {: ANSEX) < 0 do.
    ANSEX_in_text =. underbar_to_hifen_all ANSEX_in_text
end.

if. rb8 -: '1' do.
 NB. write ANSEX as text file
 ANSEX_in_text wtf_usr ed6
end.
if. rb9 -: '1' do.
 NB. append ANSEX as text file
 current_content =. rff_usr ed6
 new_content =. ANSEX_in_text, current_content
 new_content wtf_usr ed6
end.

TEXTAREA_00_VALUE =: rff_usr ed6

catch. NB. -----
reply_msg =. 'error occured during the operation'
end. NB. -----
reply_msg
)
NB. end of creation
