NB. begin_web_server_jconsole.ijs
NB. begin_jsocket_web_form_server_for_j_function_jconsole.ijs
NB. begin_jsocket_web_form_server_for_j_function_jconsole_2023_11_01.ijs

NB. By Yuji Suda
NB. g.ysuda@gmail.com

NB. -------------------------
NB. --- some system tools ---
NB. -------------------------

NB. ====================================================================================================
NB. screen output, argument should be string
screen_out =: 3 : 0
y 1!:2 >2
)

NB. ====================================================================================================
NB. alternative definition
print =: screen_out

NB. ====================================================================================================
NB. pwd print working directory
pwd =: 3 : 0
1!:43 ''
)

NB. ====================================================================================================
NB.  change directory
cddir =: 3 : 0
1!:44 y
)

NB. ====================================================================================================
NB. alternative definition
change_dir =: cddir
cdir =: cddir

NB. ====================================================================================================
NB. keyboard input string
keyin =: 3 : 0
1!:1 <1
)

NB. ====================================================================================================
NB. scroll screen by arg number of lines
scroll_up_screen =: 3 : 0
rep =. 0
while. rep<y do.
  print CRLF
  rep =. rep + 1
end.
)

NB. ------------------------
NB. --- support function ---
NB. ------------------------

NB. ====================================================================================================
NB. change directory with reconfirmation
NB. argument is desired working directory in string
change_working_directory =: 3 : 0
  cdir y
  print CRLF
  print 'working directory is set at ', y
  a_confirmation =. pwd 0
  print 'pwd command returns:        ', a_confirmation
  print CRLF
1
)

NB. --------------------
NB. ---  main script ---
NB. --------------------

NB. ====================================================================================================
NB. main script to begin jsocket_web_form_server_for_j_function in a given OS
begin_jsocket_web_form_server_for_j_function_in_jconsole =: 3 : 0

NB. check current OS
CURRENT_OS =: 9!:12'' NB. 9!:12 '' returns current os  5: mac/unx/linux    6:windows

NB. check current J version, too
CURRENT_J_VER =: 9!:14 ''

NB. change directory to current OS specific working directory
if. CURRENT_OS = 6 do.
    print '   your OS is windows'
    YOUR_OS            =: 'windows'
    INSTALL_DIR        =: 'c:/making'
    SUB_DIR            =: '/jconsole/jsocket/'
    SUB_DIR_APP        =: '/jconsole/'
    ENCODING_CODE_INFO =: 'Shift-JIS'        

    a_working_directory =. INSTALL_DIR, SUB_DIR
    change_working_directory a_working_directory

end.

if. CURRENT_OS = 5 do.
    print '   your OS is mac/unix'
    YOUR_OS            =: 'mac'
    INSTALL_DIR        =: _1}.2!:0 'echo $HOME'
    INSTALL_DIR        =: INSTALL_DIR, '/making'
    SUB_DIR            =: '/jconsole/jsocket/'
    SUB_DIR_APP        =: '/jconsole/'
    ENCODING_CODE_INFO =: 'UTF-8'        

    a_working_directory =. INSTALL_DIR, SUB_DIR
    change_working_directory a_working_directory
end.

NB. reconfirmation of working directory
a_selected_dir =. pwd 0
print 'working directory confirmation = ', a_selected_dir

NB. load specified application script stored in working directory

load 'jsocket_web_form_server_for_j_function_jconsole.ijs'
". 'start_web_form_server_for_j_function 0'
1
)

NB. ====================================================================================================
NB. alternative definition
begin =: begin_jsocket_web_form_server_for_j_function_in_jconsole

NB. ====================================================================================================
NB. execute the following on loading
scroll_up_screen 50
print '   please type begin 0 to start server'
print '   begin 0'
