NB. jsocket_web_form_server_for_j_function_jconsole.ijs
NB. jsocket_web_form_server_for_j_function_jconsole_c_print2_trans_shell.ijs
NB. jsocket_web_form_server_for_j_function_jconsole_c_print2_trans_shell_2024_01_06a.ijs
NB.

NB. Yuji Suda
NB. g.ysuda@gmail.com
NB. encoding code: UTF-8

NB. The socket communication of this application is based on
NB. J's Studio->Labs->Socket Driver Server and Socket Driver - Client

NB. This application is for jconsole.exe (windows) and jconsole (mac and Linux).
NB. The script is valid for qt terminal but it may fail to display messages during
NB. the operation.

NB. See. https://code.jsoftware.com/wiki/Guides/Asynchronous_GUI#J_Processing

NB. Initially, screen output messages were written in Japanese, but finally
NB. screen out messages have been written in English in order to avoid mismatching
NB. in the encoding code of Japanese windows jconsole.exe to jconsoles of mac and Linux.

NB. Encoding-code for jconsole.exe in Japanese windows is shift-JIS, whereas
NB. the code is UTF-8 in mac and Linux jconsole.

NB. There are remaining commented out Japanese messages for convenience.

NB. *===================================================================================================
NB. load drivers for socket 
load 'socket'
coinsert 'jsocket'

NB. *===================================================================================================
load 'global_variables_jconsole.ijs'
load 'support_tools_jconsole.ijs'

ACCESS_METHOD =: ''

J_VERSION =: 4{.CURRENT_J_VER

NB. -------------------------
NB. --- some system tools ---
NB. -------------------------

NB. ====================================================================================================
NB. write_str_to_file_in_usr_dir
wtf_usr =: 4 : 0
a_file_path =. INSTALL_DIR, '/usr/', y
x wtf a_file_path
1
)

NB. ====================================================================================================
NB. append_str_to_file_in_usr_dir
append_it_usr =: 4 : 0
a_file_path =. INSTALL_DIR, '/usr/', y
x append_it a_file_path
1
)

NB. ====================================================================================================
NB. read_str_from_file_in_usr_dir
rff_usr =: 3 : 0
a_file_path =. INSTALL_DIR, '/usr/', y
rff a_file_path
)

NB. ====================================================================================================
NB. store all lines in boxes
store_all_lines_in_boxes =: 3 : 0
v =. y
boxed_lines =. ''
lineNo =. 0
total_Ln =. +/CRLF E. y
NB.for. (i. (+/ CRLF E. y)) do.
while. lineNo < total_Ln do.
 aLine =. take_one_line v
 print (3j0 ":lineNo),' ', aLine  NB. , CRLF  NB. monitor taken line
 v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
 boxed_lines =. boxed_lines,aLine;'dummy'
 lineNo =. 1 + lineNo
end.
(lineNo , 2) $ boxed_lines
)

NB. ====================================================================================================
NB. on line real time translation using translate_shell available in mac and Linux
NB. abandon use of this mechanism for the time being
NB.print2 =: 3 : 0
NB.if. (YOUR_OS -: 'mac') *. (TRANSLATE_SHELL_FLG = 1) do.
 NB.a_cmd =. '''', 'trans en:ja -b "', y, '"', ''''
 NB.print _1}.2!:0 ".a_cmd
NB.else.
 NB.print y
NB.end.
NB.)

NB. ====================================================================================================
NB. print2 defined above is not used for the time being, so it is identical with print
print2 =: print

NB. -------------------------
NB. --- utility functions ---
NB. -------------------------

NB. *===================================================================================================
prepare_boxed_two_char_digit_00_to_98 =: 3 : 0
c =. ;/i.99
d =. ": (L:0) c
e =. '00',(L:0) d
f =. _2{.(L:0) e
BOXED_TWO_CHAR_DIGIT_00_TO_98 =: f
1
)

NB. *===================================================================================================
reload_app_def_file =: 3 : 0
a_file_path =. 'app/', y, '/web_form_app_definition_file.ijs'
a_src =. rff a_file_path
a_src wtf 'web_form_app_definition_file.ijs'
print a_file_path, ' --> ', CRLF, 'web_form_app_definition_file.ijs', CRLF, 'copy operation done'
1
)

NB. *===================================================================================================
rmapp2 =: 3 : 0
NB. specify app folder
NB.a_path =. 'dir ', '''', 'app/', y, '/*.ijs', ''''
a_path =. 'dir ', '''', 'app/', y, '/*.*', ''''
print a_path
ijs_list =. ". a_path
total_flnum =. 0 { $ijs_list
cnt =. 0
while. cnt < total_flnum do.
  a_file =. >0{cnt{ijs_list
  rm_path =. 'rm ', '''', 'app/', y, '/', a_file, ''''
  print rm_path
  ". rm_path
  cnt =. cnt + 1
end.
NB. ijs file in the directory were deleted and then rmdir next
rm_path =. 'rm ', '''', 'app/', y, ''''
print rm_path
". rm_path
'rm ', y, ' done'
)

NB. *===================================================================================================
create_ijs_src_for_extract_entryID_value_for_all_the_form_controls_planned =: 4 : 0
v =. y
parse_result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print aLine
      NB. parse aLine as defined
      NB. parse_form_control_line_to_write_html_source_in_ijs aLine
      a_result =. parse_form_control_line_and_create_ijs_for_extract_entryID_value_statement aLine
      if. ($a_result) ~:0 do.
         parse_result =. parse_result, a_result, CRLF
      end.
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
print CRLF, 'parse result is as follows',CRLF
print parse_result
target_file =. 'extract_entryID_value_statements_jconsole.ijs'
parse_result wtf target_file
NB. add create specific monitoring function
define_function_for_monitoring_on_extracted_values 0
NB. 'list_up_extracted_ID_values_jconsole.ijs'  this can be used in YOUR_JOB function in plan2 definition ijs
NB.  submitted_entry_values =. monitor_entry_ID_values 0
1
)

NB. *===================================================================================================
define_function_for_monitoring_on_extracted_values =: 3 : 0
a_target_file =. 'list_up_extracted_ID_values_jconsole.ijs'
try.
   v =. rff 'extract_entryID_value_statements_jconsole.ijs'

   ('monitor_entry_ID_values =: 3 : 0', CRLF) wtf a_target_file
   'a_collection =. ' append_it a_target_file
   '''' append_it a_target_file
   NB.'クライアントから送信されたフォーム部品の値の以下の通りです。' append_it a_target_file
   'form control values submitted from client is as follows' append_it a_target_file
   '''' append_it a_target_file
   ', CRLF' append_it a_target_file
   CRLF append_it a_target_file
   
   lineNo =. 0
   total_Ln =. +/CRLF E. v
   while. lineNo < total_Ln do.
    aLine =. take_one_line v
    first_item =. 0 pick_up_x_th_item_from_space_separated_str_y aLine
    'a_collection =. a_collection, ' append_it a_target_file
     '''' append_it a_target_file
    (first_item, '  = ') append_it a_target_file
     '''' append_it a_target_file
    (', ', first_item, ', CRLF') append_it a_target_file
      CRLF append_it a_target_file
    v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
    lineNo =. 1 + lineNo
   end.
   ('a_collection', CRLF, ')', CRLF) append_it a_target_file
catch.
NB. print 'extract_entryID_valueファイルがありません'
    print 'extract_entryID_value does not exist!!'
end.
)

NB. *===================================================================================================
create_ijs_src_for_default_values_of_textbox_and_textarea_and_others =: 4 : 0
v =. y
parse_result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print aLine
      NB. parse aLine as defined
      NB. parse_form_control_line_to_write_html_source_in_ijs aLine
      a_result =. parse_form_control_and_create_ijs_for_initial_values_for_textbox_and_textarea_and_others aLine
      if. ($a_result) ~:0 do.
         parse_result =. parse_result, a_result, CRLF
      end.
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
print CRLF, 'parse result is as follows',CRLF
print parse_result
target_file =. 'initial_values_for_textbox_and_textarea_and_others_jconsole.ijs'
parse_result wtf target_file
)

NB. *===================================================================================================
define_html_code_for_controls_based_on_plan_ijs =: 3 : 0
a_transformed_src =. transform_web_def_line_to_html_src rff NEW_APP_DIR, '/', 'lines_with_def_jconsole.ijs'
print 'a_transformed_src = ', a_transformed_src
NB. そのファイルの各行について、HTMLドキュメント化し、結果を'auto_written_html_src_jconsole.ijs'に保存して終了
a_transformed_src wtf NEW_APP_DIR, '/', 'auto_written_html_src_jconsole.ijs'
1
)

NB. *===================================================================================================
parse_form_control_line_and_create_ijs_for_extract_entryID_value_statement =: 3 : 0
NB. y is a line for html control design
NB. pick up 3rd item using pick up function ; origin is zero
NB. target_file =. 'initial_values_for_textbox_and_textarea.ijs'
NB. '' wtf target_file
second_item =. 2 pick_up_x_th_item_from_slash_separated_str_y y
print '2nd item = ', second_item
NB. if. second_item -: '部品テキストボックス' do.
if. second_item -: 'TEXTBOX' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'TEXTBOX_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'textbox', a_num, ''''
  return.
end.
NB.if. second_item -: '部品テキストエリア' do.
if. second_item -: 'TEXTAREA' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'TEXTAREA_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'textarea', a_num, ''''
  return.
end.
NB.if. second_item -: '部品ラジオボタン' do.
if. second_item -: 'RADIOBUTTON' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'RADIO_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'radiobutton', a_num, ''''
  return.
end.
NB.if. second_item -: '部品チェックボックス' do.
if. second_item -: 'CHECKBOX' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'CHECKBOX_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'checkbox', a_num, ''''
  return.
end.
NB.if. second_item -: '部品チェックリスト' do.
if. second_item -: 'CHECKLIST' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'CHECKLIST_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'checklist', a_num, ''''
  return.
end.
NB.if. second_item -: '部品ドロップダウン' do.
if. second_item -: 'DROPDOWN' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'DROPDOWN_', a_num, '_VALUE =: ', 'extract_entryID_value_and_display ', '''', 'dropdown', a_num, ''''
  return.
end.
''
)

NB. *===================================================================================================
parse_form_control_and_create_ijs_for_initial_values_for_textbox_and_textarea_and_others =: 3 : 0
NB. y is a line for html control design
NB. pick up 3rd item using pick up function ; origin is zero
NB. target_file =. 'initial_values_for_textbox_and_textarea_and_others.ijs'
NB. '' wtf target_file
second_item =. 2 pick_up_x_th_item_from_slash_separated_str_y y
print '2nd item = ', second_item
NB.if. second_item -: '部品テキストボックス' do.
if. second_item -: 'TEXTBOX' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 7 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'TEXTBOX_', a_num, '_VALUE =: ', '''', a_value, ''''
  return.
end.
NB.if. second_item -: '部品テキストエリア' do.
if. second_item -: 'TEXTAREA' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 8 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'TEXTAREA_', a_num, '_VALUE =: ', '''', a_value, ''''
  return.
end.
NB.if. second_item -: '部品チェックボックス' do.
if. second_item -: 'CHECKBOX' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 6 pick_up_x_th_item_from_slash_separated_str_y y
  src =. 'CHECKBOX_', a_num, '_VALUE =: ', '''', '''' NB. default state is unchecked
  return.
end.
NB.if. second_item -: '部品ドロップダウン' do.
if. second_item -: 'DROPDOWN' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_pair =. 6 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair
  src =. 'DROPDOWN_', a_num, '_VALUE =: ', '''', a_value, ''''
  return.
end.
NB.if. second_item -: '部品チェックリスト' do.
if. second_item -: 'CHECKLIST' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_pair =. 7 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair
  src =. 'CHECKLIST_', a_num, '_VALUE =: ', '''', a_value, ''''
  return.
end.
NB.if. second_item -: '部品ラジオボタン' do.
if. second_item -: 'RADIOBUTTON' do.
  a_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
  a_pair =. 6 pick_up_x_th_item_from_slash_separated_str_y y
  a_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair
  src =. 'RADIO_', a_num, '_VALUE =: ', '''', a_value, ''''
  return.
end.
''
)

NB. *===================================================================================================
disp_menu =: 3 : 0
NB. lay blank lines before showing menu
scroll_up_screen 20 NB.画面クリアの方法が不明なのでスクロールアップさせて見やすくした

    print ' ================= jsocket web form server manager menu (ver 0.1.1) ======================='
    print ''
    print '                   ','  system install directory: ',INSTALL_DIR
    print '                   ','                 j_version: ', J_VERSION
    print ''
    print2 ' 1 select a web form server app registered in the app directory and run it'
    print ''
    print2 ' 2 make a new web form server app based on the definition file and execute a test run'
    print2 '    (definition file: web_form_app_definition_file.ijs)'
    print2 '    (use menu E to edit the file and do not forget to save it before leaving the editor)'
    print2 '    (at the end of the creation, a test run follows. )'
    print2 '    (check app behavior and revise the definition file as needed with menu E.)'
    print2 '    (repeat revision process until the application is completed.)'
NB. print  '   ・この作業に入る前に編集中の定義ファイルが保存済であることを確認して下さい。'
    print ''
    print2 ' C create a new definition file with utility web form application and activate menu 2'
    print2 '    (definition file: web_form_app_definition_file.ijs)'
    print2 '    (will be created with the utility web form application.)'
    print2 '    (On finishing the creation, above menu 2 is issued in succession. )'
    print ''
NB. print  ' R 登録済アプリの定義ファイルをの作業ディレクトリへ複写（登録後の改訂作業用）'
    print2 ' R reload app definition file from already registered app (use menu E for a revision)'
    print ''
    print2 ' E start external Editor for revision of web form app definition file'
    print2 '    (windows user is guided to issue built-in notepad bat file)'
    print2 '    (in mac and Linux emacs will be issued, if it has been installed)'
    print2 '    (if not, OS built in nano editor usage guide is displayed. )'
    print ''
    print2 ' D delete application from the registration directory'
    print ''
    print2 ' V version history'
    print ''
    print2 ' Q quit this menu'
NB. print CRLF, 'メニュー番号を入力して下さい。終了は Q です'
    print ''
    print2 'input your menu selection.'
    selection =. keyin 8
    if. ($selection) = 0 do.
     selection =. '0'
    end.
NB. print '入力されたメニュー = ', selection
    selection
)

NB. *===================================================================================================
list_current_app =: 3 : 0
NB. print CRLF, '現在登録されているアプリケーションは以下の通りです。 '
    print CRLF, 'These are applications registered currently'
CONTENT_OF_DIR =: dir INSTALL_DIR, SUB_DIR, 'app/*'
CONTENT_OF_DIR save_array_number_data_as_text_file 'buffer.txt'
cnt =. 0
max =. 0 { $ CONTENT_OF_DIR
CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: ''
scroll_up_screen 20
if. max = 0 do.
    NB. print CRLF, '現在アプリケーション の登録はありません'
        print CRLF, 'No application is registered at the present'
else.
  while. cnt < max do.
    app =. > 0{ cnt { CONTENT_OF_DIR 
    print (3j0":cnt), ' ', app
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF, app, CRLF
    cnt =. 1 + cnt
  end.
  if. YOUR_OS -: 'mac' do.
    NB. sort and redisplay are needed in this case
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF wtf 'curApp.txt'
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: 2!:0 'cat curApp.txt | sort'
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF wtf 'curApp.txt' NB. sorted list
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF_with_number =: 2!:0 'awk -f addNR.awk curApp.txt'

    CONTENT_OF_DIR =: store_all_lines_in_boxes CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF
    
    scroll_up_screen 20
    print CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF_with_number
    
  end.
    NB. print CRLF, '以上が現在登録されているアプリケーションです。 '
        print CRLF, 'These are applications registered currently'
    NB. print CRLF, '実行したいアプリケーションの番号を入力して下さい'
        print2 CRLF, 'input application number to be executed'
        app_num =. keyin 0
  try.
   selected_app =. >0{(".app_num){CONTENT_OF_DIR
    NB. print CRLF, ' ', selected_app, ' が選択されました'
        print CRLF, ' ', selected_app, ' has been selected'
    NB. print CRLF, 'enter key でこのアプリケーションを実行します。'
        print CRLF, 'hit enter key to execute it'
    a_cmd =. 'load ', '''','app/', selected_app, '/main_jconsole.ijs', ''''
    NEW_APP_DIR =: 'app/', selected_app  NB. try this
    scroll_up_screen 20
    print CRLF, a_cmd, CRLF
    ".a_cmd
    ". 'start 0'
    NB. print CRLF, selected_app, ' が終了しました'
        print CRLF, selected_app, ' has been ended'
  catch.
    NB. print CRLF, '選択でエラーが発生しました。'
        print CRLF, 'Error has occurred in number selection'
  end.
end.
)

NB. *===================================================================================================
list_current_app_without_app_exec =: 3 : 0
NB. print CRLF, '現在登録されているアプリケーションは以下の通りです。 '
    print CRLF, 'These are applications registered currently'
CONTENT_OF_DIR =: dir INSTALL_DIR, SUB_DIR, 'app/*'
CONTENT_OF_DIR save_array_number_data_as_text_file 'buffer.txt'
scroll_up_screen 20
cnt =. 0
max =. 0 { $ CONTENT_OF_DIR
CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: ''

while. cnt < max do.
  app =. > 0{ cnt { CONTENT_OF_DIR 
  print (3j0":cnt), ' ', app
  CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF, app, CRLF
  cnt =. 1 + cnt
end.
if. YOUR_OS -: 'mac' do.
    NB. sort and redisplay are needed in this case
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF wtf 'curApp.txt'
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF =: 2!:0 'cat curApp.txt | sort'
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF wtf 'curApp.txt' NB. sorted list
    CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF_with_number =: 2!:0 'awk -f addNR.awk curApp.txt'
    
    CONTENT_OF_DIR =: store_all_lines_in_boxes CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF

    scroll_up_screen 20
    print CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF_with_number
    
end.
NB. print CRLF, '以上が現在登録されているアプリケーションです。 '
    print CRLF, 'These are applications registered currently'
)

NB. *===================================================================================================
issue_making_def_file_web_app_and_activate_menu_2 =: 3 : 0

selected_app =. 'making_of_app_def_file_jconsole'
print CRLF, ' ', selected_app, ' has been selected'
print CRLF, 'hit enter key to execute it'
a_cmd =. 'load ', '''','systemApp/', selected_app, '/main_jconsole.ijs', ''''
NEW_APP_DIR =: 'systemApp/', selected_app  NB. try this
scroll_up_screen 20
print CRLF, a_cmd, CRLF
".a_cmd
". 'start 0'
NB. print CRLF, selected_app, ' が終了しました'
    print CRLF, selected_app, ' has been ended'
NB. next issue menu 2 here ...
)

NB. *===================================================================================================
extract_planned_app_name_folder_without_space =: 3 : 0
APP_DEF_FILE_READY =: 0
NB.try.
 APP_PLAN =: line_count_check_of_multi_line_str_y rff 'web_form_app_definition_file.ijs'
 aLine =. 'NB./*/APP_FOLDER_NAME' extract_specific_first_line_with_x_str APP_PLAN
 HITLINE =: aLine
 print 'HITLINE for APP_FOLDER_NAME => ', HITLINE
 item_cnt =. '/' count_items_with_separator_chr_x HITLINE
 print 'item cnt of HITLINE: ', ":item_cnt
 if. item_cnt = 4 do.
   aFoo =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
   NB. print CRLF, 'info fileに設定されたアプリケーションフォルダ名は ', CRLF, aFoo, ' です'
   a_fields_cnt =. ' ' count_items_with_separator_chr_x aFoo
   print 'fields cnt: ', ":a_fields_cnt
   if. (' ' count_items_with_separator_chr_x aFoo) = 1 do.
      APP_DEF_FILE_READY =: 1
      aFoo
   else.
      print aFoo
      aFoo_err =. 'app folder name MUST NOT CONTAIN space character'
      print aFoo_err, CRLF, 'hit enter to proceed'
      dummy =. keyin 0  NB. 
   end.
 else.
   aFoo =. 'no app definition file is found'
   print aFoo
 end.
NB.catch.
NB. aFoo =. '定義ファイルはありません。既存アプリ選択(R)か新規作成(N)が必要です。'
NB. aFoo =. 'no app definition file is found'
NB.end.
aFoo
)

NB. *===================================================================================================
extract_planed_app_name_folder =: 3 : 0
APP_DEF_FILE_READY =: 0
try.
 APP_PLAN =: line_count_check_of_multi_line_str_y rff 'web_form_app_definition_file.ijs'
 aLine =. 'NB./*/APP_FOLDER_NAME' extract_specific_first_line_with_x_str APP_PLAN
 HITLINE =: aLine
 aFoo =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
 NB. print CRLF, 'info fileに設定されたアプリケーションフォルダ名は ', CRLF, aFoo, ' です'
 APP_DEF_FILE_READY =: 1
 aFoo
catch.
NB. aFoo =. '定義ファイルはありません。既存アプリ選択(R)か新規作成(N)が必要です。'
    aFoo =. 'no app definition file is found'
end.
aFoo
)

NB. *===================================================================================================
check_def_line_format =: 3  : 0
NB. check all_def_lines_jconsole.ijs content for appropriateness to transform html doc
NB. return 1 if no problem, return 0 if problem exist in the web form control definition
NB. read each line of lines_with_def_jconsole.ijs and parse it to form html src
v =. y

parse_result =. ''

BOXED_TWO_DIGIT_CONTROL_ID_TEXTBOX     =: <'--'
BOXED_TWO_DIGIT_CONTROL_ID_TEXTAREA    =: <'--'
BOXED_TWO_DIGIT_CONTROL_ID_CHECKBOX    =: <'--'
BOXED_TWO_DIGIT_CONTROL_ID_DROPDOWN    =: <'--'
BOXED_TWO_DIGIT_CONTROL_ID_CHECKLIST   =: <'--'
BOXED_TWO_DIGIT_CONTROL_ID_RADIOBUTTON =: <'--'

for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 NB. pick up 2nd item of aLine separated with slash, origin is zero
 a_2nd_item =. 2 pick_up_x_th_item_from_slash_separated_str_y aLine
 a_total_of_items =. '/' num_of_items aLine  NB. '/' is 2 with three items in the line
 print (3j0":a_total_of_items), ' ', a_2nd_item, ' ', aLine
 if. a_total_of_items = 4 do.
        if. a_2nd_item -: 'HTML_TITLE' do.
            a_title  =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
        end.
        if. a_2nd_item -: 'HTML_REMARK' do.
            a_remark =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
        end.
 end.
 if. a_total_of_items > 4 do.
    NB. form control definition line has items more than 3, transform def to html src as defined
    NB. if. a_2nd_item -: '部品テキストボックス' do.
        if. a_2nd_item -: 'TEXTBOX' do.
          parse_result =. parse_result, ": check_spec_textbox_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
    NB. if. a_2nd_item -: '部品テキストエリア' do.
        if. a_2nd_item -: 'TEXTAREA' do.
            parse_result =. parse_result, ": check_spec_textarea_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
    NB. if. a_2nd_item -: '部品チェックボックス' do.
        if. a_2nd_item -: 'CHECKBOX' do.
            parse_result =. parse_result, ": check_spec_checkbox_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
    NB. if. a_2nd_item -: '部品ドロップダウン' do.
        if. a_2nd_item -: 'DROPDOWN' do.
            parse_result =. parse_result, ": check_spec_dropdown_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
    NB. if. a_2nd_item -: '部品チェックリスト' do.
        if. a_2nd_item -: 'CHECKLIST' do.
            parse_result =. parse_result, ": check_spec_checklist_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
    NB. if. a_2nd_item -: '部品ラジオボタン' do.
        if. a_2nd_item -: 'RADIOBUTTON' do.
            parse_result =. parse_result, ": check_spec_radiobutton_def aLine
	  if. CHECK_RESULT = 0 do.
	    print CRLF, aLine, CRLF, 'above definition is not appropriate for the system', CRLF, parse_result, CRLF
	    print 'hit enter to proceed'
            dummy =. keyin 0
            0
	    return.
	  end.
        end.
 end.
 NB. parse_result =. parse_result, a_2nd_item, CRLF
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
print CRLF, 'no problem is found in the web control definition line',CRLF
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
extract_planed_app_html_title =: 3 : 0
NB. APP_PLAN =: rff 'web_form_app_definition_file.ijs'
aLine =. 'NB./*/HTML_TITLE' extract_specific_first_line_with_x_str APP_PLAN
HITLINE =: aLine
aFoo =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
NB. print 'info fileに設定されたアプリケーション HTML_TITLEは ', aFoo, ' です'
    print 'info file contains HTML_TITLE: ', aFoo
aFoo
)

NB. *===================================================================================================
extract_planed_app_html_remark =: 3 : 0
NB. APP_PLAN =: rff 'web_form_app_definition_file.ijs'
aLine =. 'NB./*/HTML_REMARK' extract_specific_first_line_with_x_str APP_PLAN
HITLINE =: aLine
aFoo =. 3 pick_up_x_th_item_from_slash_separated_str_y aLine
NB. print 'info fileに設定されたアプリケーション HTML_REMARKは ', aFoo, ' です'
    print 'info file contains HTML_REMARK: ', aFoo
aFoo
)

NB. *===================================================================================================
extract_web_control_def_lines =: 3 : 0
tmp =. 'NB./*/' extract_specific_line_with_x_str_and_return_result y
tmp =. 'APP_FOLDER_NAME' exclude_specific_line_with_x_str_and_return_result tmp
tmp =. 'HTML_TITLE' exclude_specific_line_with_x_str_and_return_result tmp
tmp =. 'HTML_REMARK' exclude_specific_line_with_x_str_and_return_result tmp
tmp
)

NB. *===================================================================================================
extract_web_app_def_lines =: 3 : 0
tmp =. 'NB./*/' extract_specific_line_with_x_str_and_return_result y
NB. tmp =. 'APP_FOLDER_NAME' exclude_specific_line_with_x_str_and_return_result tmp
NB. tmp =. 'HTML_TITLE' exclude_specific_line_with_x_str_and_return_result tmp
NB. tmp =. 'HTML_REMARK' exclude_specific_line_with_x_str_and_return_result tmp
tmp
)

NB. *===================================================================================================
transform_web_def_line_to_html_src =: 3 : 0
NB. read each line of lines_with_def_jconsole.ijs and parse it to form html src
v =. y
parse_result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 NB. pick up 2nd item of aLine separated with slash, origin is zero
 a_2nd_item =. 2 pick_up_x_th_item_from_slash_separated_str_y aLine
 a_total_of_items =. '/' num_of_items aLine  NB. '/' is 2 with three items in the line
 print (3j0":a_total_of_items), ' ', a_2nd_item, ' ', aLine
 if. a_total_of_items = 3 do.
    NB. if. a_2nd_item -: '改行' do.
        if. a_2nd_item -: 'NEWLINE' do.
            parse_result =. parse_result, '<br>', CRLF
        end.
    NB. if. a_2nd_item -: '水平線' do.
        if. a_2nd_item -: 'HORIZONTALLINE' do.
            parse_result =. parse_result, '<hr>', CRLF
        end.
    NB. if. ((a_2nd_item -: '改行')+:(a_2nd_item -: '水平線')) do.
        if. ((a_2nd_item -: 'NEWLINE')+:(a_2nd_item -: 'HORIZONTALLINE')) do.
            NB.parse_result =. parse_result, '<br>', a_2nd_item, '<br>', CRLF
            parse_result =. parse_result, a_2nd_item, '<br>', CRLF
        end.
 end.
 FORM_CONTROL_DEF_ERR =: ''  NB. no error at the beginning
 if. a_total_of_items > 3 do.
    NB. form control definition line has items more than 3, transform def to html src as defined
    NB. if. a_2nd_item -: '部品テキストボックス' do.
        if. a_2nd_item -: 'TEXTBOX' do.
          try.  
            parse_result =. parse_result, transform_textbox_def aLine
          catch.
            NB. FORM_CONTROL_DEF_ERR =: '<br>部品テキストボックスの定義でエラーが発生しました<br>', CRLF
                FORM_CONTROL_DEF_ERR =: '<br>error has occurred in the definition of TEXTBOX<br>', CRLF
                parse_result =. parse_result, FORM_CONTROL_DEF_ERR
          end.
        end.
    NB. if. a_2nd_item -: '部品テキストエリア' do.
        if. a_2nd_item -: 'TEXTAREA' do.
            parse_result =. parse_result, transform_textarea_def aLine
        end.
    NB. if. a_2nd_item -: '部品チェックボックス' do.
        if. a_2nd_item -: 'CHECKBOX' do.
            parse_result =. parse_result, transform_checkbox_def aLine
        end.
    NB. if. a_2nd_item -: '部品ドロップダウン' do.
        if. a_2nd_item -: 'DROPDOWN' do.
            parse_result =. parse_result, transform_dropdown_def aLine
        end.
    NB. if. a_2nd_item -: '部品チェックリスト' do.
        if. a_2nd_item -: 'CHECKLIST' do.
            parse_result =. parse_result, transform_checklist_def aLine
        end.
    NB. if. a_2nd_item -: '部品ラジオボタン' do.
        if. a_2nd_item -: 'RADIOBUTTON' do.
            parse_result =. parse_result, transform_radiobutton_def aLine
        end.
 end.
 NB. parse_result =. parse_result, a_2nd_item, CRLF
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
print CRLF, 'parse result is as follows',CRLF
print parse_result
parse_result NB. return value
)

NB. *===================================================================================================
check_layout =: 3 : 0
NB.if. y -: '縦置' do. preFix =. '<br>' else. preFix =. '' end.
if. y -: 'VERTICAL' do. preFix =. '<br>' else. preFix =. '' end.
preFix
)

NB. *===================================================================================================
check_spec_textbox_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt ~: 8 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of textbox definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_size       =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 6 pick_up_x_th_item_from_slash_separated_str_y y

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textbox series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_TEXTBOX do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textbox series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_TEXTBOX =: BOXED_TWO_DIGIT_CONTROL_ID_TEXTBOX, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textbox layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

if. '' -: ".a_size do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textbox size statement is not appropriate. It should be integer number'
  return.
end.
NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
check_spec_textarea_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt ~: 9 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of textarea definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_column     =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_row        =. 6 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 7 pick_up_x_th_item_from_slash_separated_str_y y

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textarea series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_TEXTAREA do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textarea series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_TEXTAREA =: BOXED_TWO_DIGIT_CONTROL_ID_TEXTAREA, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textarea layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

if. '' -: ".a_column do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textarea column size statement is not appropriate. It should be integer number'
  return.
end.

if. '' -: ".a_row do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'textarea row size statement is not appropriate. It should be integer number'
  return.
end.

NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
check_spec_checkbox_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt ~: 7 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of checkbox definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 5 pick_up_x_th_item_from_slash_separated_str_y y

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checkbox series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_CHECKBOX do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checkbox series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_CHECKBOX =: BOXED_TWO_DIGIT_CONTROL_ID_CHECKBOX, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checkbox layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
check_spec_dropdown_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt <: 6 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of dropdown definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 5 pick_up_x_th_item_from_slash_separated_str_y y

option_cnt =. item_cnt - 6
rep =. 0
while. rep < option_cnt do.
  option_def =. (6 + rep) pick_up_x_th_item_from_slash_separated_str_y y
  option_items =. '+' count_items_with_separator_chr_x option_def
  print CRLF, 'option_def and fields ', option_def, ' ', ":option_items
  if. option_items ~: 2 do.
    CHECK_RESULT =: 0
    CRLF, 'option item must be with two fields separated with + char '
    return.
  end.
  rep =. rep + 1
end.

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'dropdown series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_DROPDOWN do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'dropdown series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_DROPDOWN =: BOXED_TWO_DIGIT_CONTROL_ID_DROPDOWN, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'dropdown layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
check_spec_radiobutton_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt <: 6 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of radiobutton definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 5 pick_up_x_th_item_from_slash_separated_str_y y

option_cnt =. item_cnt - 6
rep =. 0
while. rep < option_cnt do.
  option_def =. (6 + rep) pick_up_x_th_item_from_slash_separated_str_y y
  option_items =. '+' count_items_with_separator_chr_x option_def
  print CRLF, 'option_def and fields ', option_def, ' ', ":option_items
  if. option_items ~: 2 do.
    CHECK_RESULT =: 0
    CRLF, 'option item must be with two fields separated with + char '
    return.
  end.
  rep =. rep + 1
end.

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'radiobutton series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_RADIOBUTTON do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'radiobutton series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_RADIOBUTTON =: BOXED_TWO_DIGIT_CONTROL_ID_RADIOBUTTON, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'radiobutton layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
check_spec_checklist_def =: 3 : 0
item_cnt =. '/' count_items_with_separator_chr_x y
if. item_cnt <: 7 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'number of items of checklist definition is not appropriate'
  return.
end.
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_list_num   =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 6 pick_up_x_th_item_from_slash_separated_str_y y

option_cnt =. item_cnt - 7

if. ''  -:  ". a_list_num do.
  CHECK_RESULT = : 0
  CRLF, 'option number must be integer number'
  return.
end.

if. option_cnt ~: ". a_list_num do.
  CHECK_RESULT =: 0
  CRLF, 'option number must be matched with actual number of option lists'
  return.
end.

rep =. 0
while. rep < option_cnt do.
  option_def =. (7 + rep) pick_up_x_th_item_from_slash_separated_str_y y
  option_items =. '+' count_items_with_separator_chr_x option_def
  print CRLF, 'option_def and fields ', option_def, ' ', ":option_items
  if. option_items ~: 2 do.
    CHECK_RESULT =: 0
    CRLF, 'option item must be with two fields separated with + char '
    return.
  end.
  rep =. rep + 1
end.

if. 0 = +/ (< a_series_num) E. BOXED_TWO_CHAR_DIGIT_00_TO_98 do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checklist series ID is not appropriate. It should be two digit char between 00 and 98'
  return.
end.

if. 1 = +/ (< a_series_num) E. BOXED_TWO_DIGIT_CONTROL_ID_CHECKLIST do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checklist series ID is duplicated. It should be unique two digit char between 00 and 98'
  return.
else.
  BOXED_TWO_DIGIT_CONTROL_ID_CHECKLIST =: BOXED_TWO_DIGIT_CONTROL_ID_CHECKLIST, < a_series_num
end.

if. 0 = +/ (< a_layout) E. 'VERTICAL'; 'HORIZONTAL' do.
  CHECK_RESULT =: 0 NB. this is error return
  CRLF, 'checklist layout statement is not appropriate. It should be either VERTICAL or HORIZONTAL'
  return.
end.

NB. OK no problems in definition line
CHECK_RESULT =: 1
1
)

NB. *===================================================================================================
transform_textbox_def =: 3 : 0
NB. first pick up each item for html src specification
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_size       =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 6 pick_up_x_th_item_from_slash_separated_str_y y
NB. default value of textbox has been already picked out as TEXTBOX_??_VALUE where ?? is a_series_num
layout_decoded =. check_layout a_layout
src =. layout_decoded, a_label, ' <input type="text" name="textbox', a_series_num, '" size="',a_size, '" value="', (".'TEXTBOX_', a_series_num, '_VALUE'), '">', CRLF
)

NB. *===================================================================================================
transform_textarea_def =: 3 : 0
NB. first pick up each item for html src specification
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_col        =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_row        =. 6 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 7 pick_up_x_th_item_from_slash_separated_str_y y
NB. default value of textbox has been already picked out as TEXTAREA_??_VALUE where ?? is a_series_num
layout_decoded =. check_layout a_layout
layout_decoded =. '<br>' NB. may be this is better default 縦置
src =. layout_decoded, a_label, '<br><textarea  name="textarea', a_series_num, '" cols="', a_col,'" rows="', a_row,  '">', (".'TEXTAREA_', a_series_num, '_VALUE'), '</textarea>', CRLF
)

NB. *===================================================================================================
transform_checkbox_def =: 3 : 0
NB. first pick up each item for html src specification
a_series_num =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout     =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label      =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_value      =. 6 pick_up_x_th_item_from_slash_separated_str_y y

NB. default status of checkbox is unchecked

layout_decoded =. check_layout a_layout
a_id_value_name =. 'CHECKBOX_', a_series_num, '_VALUE'
a_status =. ''
print ' **** a_value , a_id_value_name and its value ', a_value, ' ', a_id_value_name, ' ', ".a_id_value_name
if. a_value -: (". a_id_value_name) do.
   a_status =. 'checked'
end.

src =. layout_decoded, '<input type="checkbox" name="checkbox', a_series_num, '" value="', a_value, '" ', a_status, '>', a_label, CRLF NB. '<br>', CRLF
)

NB. *===================================================================================================
transform_radiobutton_def =: 3 : 0
NB. first pick up each item for html src specification
a_total_items   =. '/' num_of_items y NB. use to calculate number of radiobuttons
a_series_num    =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout        =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label         =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_num_of_button =. a_total_items - 6

NB. default status of checkbox is unchecked

layout_decoded =. check_layout a_layout

NB. first describe radiobutton label
NB. src =. '<br>', a_label, '<br>'
NB. src =. a_label, '<br>'
src =. a_label
cnt =. 0
while. cnt < a_num_of_button do.
    a_pick_up_location =. cnt + 6
    a_pair =.  a_pick_up_location pick_up_x_th_item_from_slash_separated_str_y y
    a_option_label =. 0 pick_up_x_th_item_from_plus_separated_str_y a_pair
    a_option_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair

    a_id_value_name =. 'RADIO_', a_series_num, '_VALUE'
    a_status =. ''
    print ' **** a_option_value , a_id_value_name and its value ', a_option_value, ' ', a_id_value_name, ' ', ".a_id_value_name
    if. (cnt = 0) *. (ACCESS_METHOD -: 'GET') do. a_status =. 'checked' end.
    if. a_option_value -: (". a_id_value_name) do.
       a_status =. 'checked'
    end.
    src =. src, '<input type="radio" name="radiobutton', a_series_num, '" value="', a_option_value, '" ', a_status, '>', a_option_label, layout_decoded, CRLF  NB. '<br>', CRLF
    cnt =. 1 + cnt
end.
src  NB. return src
)

NB. *===================================================================================================
transform_checklist_def =: 3 : 0
NB. first pick up each item for html src specification
a_total_items =. '/' num_of_items y NB. use to calculate number of radiobuttons
a_series_num  =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout      =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_size        =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_label       =. 6 pick_up_x_th_item_from_slash_separated_str_y y
a_num_of_button =. a_total_items - 7

NB. default status of checklist selection is top item

layout_decoded =. check_layout a_layout

NB. first describe chekclist label
src =. layout_decoded, a_label
src =. src, '<select name="checklist', a_series_num, '" size="', a_size, '">', CRLF
cnt =. 0
while. cnt < a_num_of_button do.
    a_pick_up_location =. cnt + 7
    a_pair =.  a_pick_up_location pick_up_x_th_item_from_slash_separated_str_y y
    a_option_label =. 0 pick_up_x_th_item_from_plus_separated_str_y a_pair
    a_option_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair
    
    a_id_value_name =. 'CHECKLIST_', a_series_num, '_VALUE'
    a_status =. ''
    print ' **** a_option_value , a_id_value_name and its value ', a_option_value, ' ', a_id_value_name, ' ', ".a_id_value_name
    if. (cnt = 0) *. (ACCESS_METHOD -: 'GET') do. a_status =. 'selected' end.
    if. a_option_value -: (". a_id_value_name) do.
       a_status =. 'selected'
    end.
    src =. src, '<option value="', a_option_value, '" ', a_status, '>', a_option_label, CRLF
    cnt =. 1 + cnt
end.
src =. src, '</select>', CRLF NB. , layout_decoded, CRLF
src  NB. return src
)

NB. *===================================================================================================
transform_dropdown_def =: 3 : 0
NB. first pick up each item for html src specification
a_total_items   =. '/' num_of_items y NB. use to calculate number of radiobuttons
a_series_num    =. 3 pick_up_x_th_item_from_slash_separated_str_y y
a_layout        =. 4 pick_up_x_th_item_from_slash_separated_str_y y
a_label         =. 5 pick_up_x_th_item_from_slash_separated_str_y y
a_num_of_button =. a_total_items - 6

NB. default status of dropdown selection is top item

layout_decoded =. check_layout a_layout

NB. first describe dropdown label
src =. layout_decoded, a_label
src =. src, '<select name="dropdown', a_series_num, '">'
cnt =. 0
while. cnt < a_num_of_button do.
    a_pick_up_location =. cnt + 6
    a_pair =.  a_pick_up_location pick_up_x_th_item_from_slash_separated_str_y y
    a_option_label =. 0 pick_up_x_th_item_from_plus_separated_str_y a_pair
    a_option_value =. 1 pick_up_x_th_item_from_plus_separated_str_y a_pair
    
    a_id_value_name =. 'DROPDOWN_', a_series_num, '_VALUE'
    a_status =. ''
    print ' **** a_option_value , a_id_value_name and its value ', a_option_value, ' ', a_id_value_name, ' ', ".a_id_value_name
    if. (cnt = 0) *. (ACCESS_METHOD -: 'GET') do. a_status =. 'selected' end.
    if. a_option_value -: (". a_id_value_name) do.
       a_status =. 'selected'
    end.
    src =. src, '<option value="', a_option_value, '" ', a_status, '>', a_option_label, CRLF
    cnt =. 1 + cnt
end.
src =. src, '</select>', CRLF NB. , layout_decoded, CRLF
src  NB. return src
)

NB. *===================================================================================================
app_reload_question =: 3 : 0
list_current_app_without_app_exec 0
NB. print CRLF, '改訂用に作業領域に複写したいアプリケーションの番号を入力して下さい'
    print CRLF, 'input app number for copying def file revision'
app_num =. keyin 0
try.
     selected_app =. >0{(".app_num){CONTENT_OF_DIR
 NB. print CRLF, ' ', selected_app, ' が選択されました'
     print CRLF, ' ', selected_app, ' is selected'

 NB. print CRLF, 'このアプリの定義ファイルを複写しても良いですか ？(Yes/No)'
     print2 CRLF, 'proceed to copy of def file ?(Yes/No)'
     your_choice =. keyin 8
     if. your_choice -: 'Yes' do.
           reload_app_def_file selected_app
       NB. print CRLF, selected_app, ' の定義ファイルを作業領域へ複写しました。'
           print CRLF, selected_app, ' def file has been copied to working region.'
     else.
       NB. print CRLF, 'アプリ名の定義ファイルの複写は拒否されました。'
           print CRLF, 'copy has been cancelled'
     end.
catch.
  NB.print '番号選択でエラーが発生しました。'
     print 'error occurred in app number selection'
end.
1
)

NB. *===================================================================================================
register_newly_created_app_def_file_to_working_dir =: 3 : 0
try.
     a_src =. rff 'app_plan_created_with_posted_info.ijs'
     a_src wtf 'web_form_app_definition_file.ijs'
 NB. print CRLF, '新しく作成された定義ファイルを作業ディレクトリへ複写しました。'
     print CRLF, 'newly created app def file has been copied to working region'
catch.
     print CRLF, 'Error has occurred in copy operation. Source file does not exists.'
end.
1
)

NB. *===================================================================================================
app_delete_question =: 3 : 0
    list_current_app_without_app_exec 0
NB. print CRLF, '削除したいアプリケーションの番号を入力して下さい'
    print2 CRLF, 'input app number for deletion'
    app_num =. keyin 0
try.
     selected_app =. >0{(".app_num){CONTENT_OF_DIR
 NB. print CRLF, ' ', selected_app, ' が選択されました'
     print CRLF, ' ', selected_app, ' was selected'

 NB. print CRLF, 'このアプリを削除しても良いですか ？(Yes/No)'
     print2 CRLF, 'is it OK to delete this app?(Yes/No)'
     your_choice =. keyin 8
     if. your_choice -: 'Yes' do.
        NB. rmapp 
            rmapp2 selected_app
        NB. print CRLF, selected_app, ' は削除されました。'
            print CRLF, selected_app, ' has been deleted'
     else.
        NB. print CRLF, 'アプリ名の削除は拒否されました。'
            print CRLF, 'deletion of app has been cancelled'
     end.
catch.
  NB. print '番号選択でエラーが発生しました。'
      print 'error has occurred in number selection'
end.
1
)

NB. *===================================================================================================
app_name_check_and_rmapp_if_exist =: 3 : 0
APP_NAME_CONFLICTED_AND_DELETED_FLG =: 0
APP_NAME_CONFLICTED_FLG =: 0
NB. print CRLF, 'webForm対応新規アプリケーションの基本枠組みを作成します'
    print CRLF, 'webForm application will be created'
NB. print CRLF, '現在登録されているアプリケーションは以下のとおりです。'
    print CRLF, 'these are the apps currently registered'
list_current_app_without_app_exec 0
NB. print '新たに定義されたアプリ名称', CRLF
    print 'newly specified app name', CRLF
NEXT_APP_NAME =: extract_planed_app_name_folder 0
name_check =. NEXT_APP_NAME check_full_line_match_with_x_in_y_CRLF_separated_str CURRENT_APP_IN_ONE_STR_SEPARATED_WITH_CRLF 
if. name_check = 1 do.
  APP_NAME_CONFLICTED_FLG =: 1
  NB. print CRLF, 'このアプリ名称は既に登録済みです。既存アプリを削除しても良いですか ？(Yes/No)'
      print2 CRLF, 'this application has been already registered. Is it OK to delete it?(Yes/No)'
  your_choice =. keyin 8
  if. your_choice -: 'Yes' do.
    NB. rmapp 
    rmapp2 NEXT_APP_NAME
    NB. print CRLF, NEXT_APP_NAME, 'は削除されました。'
        print CRLF, NEXT_APP_NAME, ' has been deleted'
    APP_NAME_CONFLICTED_AND_DELETED_FLG =: 1
    APP_NAME_CONFLICTED_FLG =: 0
  else.
    NB. print CRLF, 'アプリ名の重複があり、削除は拒否されました。'
        print CRLF, 'app name conflict exists and deletion has been cancelled'
    APP_NAME_CONFLICTED_AND_DELETED_FLG =: 0
  end.
else.
  NB. print CRLF, '名称の重複はありませんでした。'
      print CRLF, 'app name conflict is not found.'
  APP_NAME_CONFLICTED_FLG =: 0  
end.
NB. print CRLF, 'enter keyで次に進みます。'
    print CRLF, 'enter key to proceed'
dummy =. keyin 8
1
)

NB. *===================================================================================================
make_new_web_form_app_for_jconsole =: 3 : 0

app_name_check_and_rmapp_if_exist 0

if. APP_NAME_CONFLICTED_FLG = 1 do.
  NB. no operation is selected, so just return
  NB. print 'アプリケーション名称の重複がありキャンセルされました。'
      print 'app name conflict exist and operation has been cancelled.'
  return.
else.
  NB. print CRLF, 'webForm対応新規アプリケーションの基本枠組みを作成します'
      print CRLF, 'webForm app will be created.'

  NB. making_of_new_app_frame 0 NB. done
  make_new_app_directory NEXT_APP_NAME
  NB. print CRLF, 'アプリケーションディレクトリ ', INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, 'が作成されました。'

  lines_with_def_jconsole =. extract_web_control_def_lines APP_PLAN
  lines_with_def_jconsole wtf 'lines_with_def_jconsole.ijs'
  lines_with_def_jconsole wtf NEW_APP_DIR, '/', 'lines_with_def_jconsole.ijs'

  NB. print CRLF, 'lines_with_def_jconsole.ijs を当該ディレクトリに保存しました。'
      print CRLF, 'lines_with_def_jconsole.ijs has been saved.'

  NB. 1 create_main_jconsole_ijs 
  make_main_jconsole_ijs 0 NB. use NEXT_APP_NAME in the function
  NB. print CRLF, 'アプリケーションの main_jconsole.ijs が作成されました。'
  
  NB. 2 create_jconsole_applications_jconsole_ijs 
  create_jconsole_applications_jconsole_ijs 0 NB. use NEXT_APP_NAME in the function
  NB. print CRLF, 'アプリケーションの jconsole_applications_jconsole.ijs が作成されました。'

  NB. 3 create_create_response_message_to_GET_method_jconsole_ijs 
  create_create_response_message_to_GET_method_jconsole_ijs 0 NB. use NEXT_APP_NAME in the function
  NB. print CRLF, 'アプリケーションの create_response_message_to_GET_method_jconsole.ijs が作成されました。'

  NB. 4 create_action_to_POST_method_jconsole_ijs
  create_action_to_POST_method_jconsole_ijs 0 NB. use NEXT_APP_NAME in the function
  NB. print CRLF, 'アプリケーションの action_to_POST_method_jconsole.ijs が作成されました。'

  print CRLF, 'プランに記述されたアプリケーションが完成しました。'
  NB. print CRLF, 'メインメニューの１で表示される登録済みアプリケーションリストの番号指定で実行可能です。'
  scroll_up_screen 20
  NB. print CRLF, '完成したアプリケーション ',NEXT_APP_NAME, ' を試行します。', CRLF
      print CRLF, 'newly created application: ',NEXT_APP_NAME, ' will be executed as trial', CRLF

  NB. start of trial exec
  a_cmd =. 'load ', '''','app/', NEXT_APP_NAME, '/main_jconsole.ijs', ''''
  NEW_APP_DIR =: 'app/', NEXT_APP_NAME  NB. try this
  print CRLF, CRLF, a_cmd, CRLF
  ".a_cmd
  ". 'start 0'
  NB. print CRLF, NEXT_APP_NAME, ' が終了しました'
      print CRLF, NEXT_APP_NAME, ' has been ended.'
  
  NB. end of trial exec
end.
NB. print CRLF, 'enter keyでmenuに戻ります'
    print CRLF, 'enter key to go back to menu'
dummy =. keyin 8
)

NB. *===================================================================================================
make_new_app_directory =: 3 : 0
NB. NEW_APP_DIR =: INSTALL_DIR, SUB_DIR, 'app/', y NB. compose full absolute path for new app
NEW_APP_DIR =: 'app/', y NB. jserver_menu_jconsole is executing at INSTALL_DIR, SUB_DIR
mkdir NEW_APP_DIR
NB. print '新しいアプリケーションのディレクトリ', ' ', NEW_APP_DIR, ' ','を作成しました。'
    print 'new directory for application: ', ' ', NEW_APP_DIR, ' ',' has been created.'
)

NB. *===================================================================================================
NB. 1 create_main_jconsole_ijs 0  NB. use global NEXT_APP_NAME
make_main_jconsole_ijs =: 3 : 0
target_file   =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/main_jconsole.ijs'

('NB. main_jconsole.ijs', CRLF) wtf target_file  NB. OK
('NB. ', NEXT_APP_NAME, CRLF) append_it target_file   NB. OK
('NB. application information',CRLF, CRLF) append_it target_file
NB.('NB. アプリケーション情報',CRLF) append_it target_file
NB.('ENCODING_CODE        =: ', '''UTF-8''', CRLF) append_it target_file  NB.OK
('ENCODING_CODE        =: ', '''', ENCODING_CODE_INFO, '''', CRLF) append_it target_file  NB.OK
a_title =. extract_planed_app_html_title 0
('APPLICATION_NAME     =: ', '''', a_title, '''', CRLF) append_it target_file
('APPLICATION_DATE     =: ', '''', (":(i.3) { date_time 0), '''', CRLF) append_it target_file
('application_folder   =. ', '''', NEXT_APP_NAME, '''', CRLF, CRLF) append_it target_file
('NB. definition of HTML for client',CRLF) append_it target_file
NB.('NB. クライアントへの応答　HTMLの定義部分',CRLF) append_it target_file
('PAGE_TITLE           =: ', '''', a_title, '''', CRLF) append_it target_file
a_remark =. extract_planed_app_html_remark 0
('PAGE_DESCRIPTION     =: ', '''', a_remark, '''', CRLF, CRLF) append_it target_file
NB. (rff 'main_jconsole_fixed_part.ijs') append_it target_file
(rff 'main_fixed_part_jconsole.ijs') append_it target_file

NB. print CRLF, 'アプリケーションの main_jconsole.ijs が作成されました。'
    print CRLF, 'main_jconsole.ijs has been created.'

target_file_2 =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/web_form_app_definition_file.ijs'
APP_PLAN wtf target_file_2
NB. print CRLF, 'web_form_app_definition_file.ijs を当該ディレクトリに保存しました。'
    print CRLF, 'web_form_app_definition_file.ijs has been saved.'
)

NB. *===================================================================================================
NB. 2 create_jconsole_applications_jconsole_ijs 0  NB. use global NEXT_APP_NAME
create_jconsole_applications_jconsole_ijs =: 3 : 0
target_file =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/jconsole_applications_jconsole.ijs'
('NB. jconsole_applications_jconsole.ijs', CRLF) wtf target_file  NB. OK
('NB. ', NEXT_APP_NAME, CRLF) append_it target_file   NB. OK
(rff 'jconsole_applications_fixed_part_jconsole.ijs') append_it target_file 
NB. print CRLF, 'アプリケーションの jconsole_applications_jconsole.ijs が作成されました。'
    print CRLF, 'jconsole_applications_jconsole.ijs has been created.'
)

NB. *===================================================================================================
NB. 3 create_create_response_message_to_GET_method_jconsole_ijs 0  NB. use global NEXT_APP_NAME
create_create_response_message_to_GET_method_jconsole_ijs =: 3 : 0
target_file =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/create_response_message_to_GET_method_jconsole.ijs'

('NB. create_response_message_to_GET_method_jconsole.ijs', CRLF) wtf target_file  NB. OK
('NB. ', NEXT_APP_NAME, CRLF) append_it target_file   NB. OK

a_remark =. extract_planed_app_html_remark 0
('NB. ', a_remark, CRLF) append_it target_file   NB. OK

a_file =. 'create_response_message_to_GET_method_part_1_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

NB. create_ijs_src_for_default_values_of_textbox_and_textarea =: 3 : 0 NB. this is ready to be used as follows
NB. html_doc 用のコントロール部品のうち、テキストボックスとテキストエリアの初期値定義を設計ijsから作成

'NB./*/' create_ijs_src_for_default_values_of_textbox_and_textarea_and_others APP_PLAN
a_file =. 'initial_values_for_textbox_and_textarea_and_others_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

a_file =. 'create_response_message_to_GET_method_part_2_jconsole.ijs' 
print CRLF, a_file
(rff a_file) append_it target_file 

NB. html_doc 用のコントロール部品のHTML記述を設計ijsから作成
define_html_code_for_controls_based_on_plan_ijs  0 NB. under development still in progress

NB. 結果はNEW_APP_DIR, '/', 'auto_written_html_src_jconsole.ijs'に保存されてもどる
NB. response_message_to_GET_method_part_3.ijs にこのhtml srcを読み込む記述を設定した

a_file =. 'create_response_message_to_GET_method_part_3_jconsole.ijs' 
print CRLF, a_file
(rff a_file) append_it target_file 

a_line =. 'html_doc =. html_doc, rff NEW_APP_DIR, ', '''', '/', '''', ', ', '''', 'auto_written_html_src_jconsole.ijs', ''''
a_line append_it target_file

NB. html_doc 用のコントロール部品の部品合体記述を設計ijsから作成
NB. define_html_doc_compose_code_based_on_plan_ijs =: 3 : 0
a_file =. 'create_response_message_to_GET_method_part_4_jconsole.ijs' 
print CRLF, a_file
(rff a_file) append_it target_file 

NB. print CRLF, 'アプリケーションの create_response_message_to_GET_method_jconsole.ijs が作成されました。'
    print CRLF, 'create_response_message_to_GET_method_jconsole.ijs has been created.'
)

NB. *===================================================================================================
NB. 4 create_action_to_POST_method_jconsole_ijs 0  NB. use global NEXT_APP_NAME
create_action_to_POST_method_jconsole_ijs =: 3 : 0
target_file =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/action_to_POST_method_jconsole.ijs'

('NB. action_to_POST_method_jconsole.ijs', CRLF) wtf target_file  NB. OK
('NB. ', NEXT_APP_NAME, CRLF) append_it target_file   NB. OK
a_remark =. extract_planed_app_html_remark 0
('NB. ', a_remark, CRLF) append_it target_file   NB. OK
a_file =. 'action_to_POST_method_part_1_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

NB. here, parse_form_control_line_and_create_ijs_for_extract_entryID_value_statement
target_file_3 =. INSTALL_DIR, SUB_DIR, 'app/', NEXT_APP_NAME, '/lines_with_def_jconsole.ijs'
print target_file_3
form_def_lines =. rff target_file_3
'NB./*/' create_ijs_src_for_extract_entryID_value_for_all_the_form_controls_planned form_def_lines 
NB. this will end with file 'extract_entryID_value_statements_jconsole.ijs' to be appended
a_file =. 'extract_entryID_value_statements_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

a_file =. 'action_to_POST_method_part_2_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

NB. append list_up_extracted_ID_values_jconsole.ijs, too to activate monitor_entry_ID_values 
a_file =. 'list_up_extracted_ID_values_jconsole.ijs'
print CRLF, a_file
(rff a_file) append_it target_file 

NB. print CRLF, 'アプリケーションの action_to_POST_method_jconsole.ijs が作成されました。'
    print CRLF, 'action_to_POST_method_jconsole.ijs has been created.'
)

NB. *===================================================================================================
initialize_response_image_bmp =: 3 : 0
a_default_bmp_img =. rff '03x03_Orange.bmp'
a_default_bmp_img wtf 'response_image.bmp'
1
)

NB. *===================================================================================================
initialize_response_image_png =: 3 : 0
a_default_png_img =. rff '03x03_Orange.png'
a_default_png_img wtf 'response_image.png'
1
)

NB. *===================================================================================================
check_hankaku_number =: 3 : 0
NB. if y is zenkaku number, print domain error and return 0
NB. if OK return number
try.
 a_number =. ".y
 if. '' -: a_number do. a_number =. 0 end.
catch.
 NB. print '数値が半角でありません。数値は半角で入力して下さい', CRLF
     print 'number is not ascii. two byte number is not allowed here', CRLF
 NB. print CRLF, 'enter keyでmenuに戻ります'
     print CRLF, 'enter key to go back to menu'
 dummy =. keyin 8
 a_number =. 0
end.
a_number
)

NB. *===================================================================================================
define_new_app_plan_src =: 3 : 0
NB. use POSTed component info to create app plan src
 horizontal_separator =. CRLF, 'NB. ==================================================================='
 horizontal_separator =. horizontal_separator,  '=================================', CRLF
 a_collection =. monitor_entry_ID_values 0 NB.受信データの抽出
 a_def =. CRLF,  'NB. Created app def file is as follows', CRLF
 a_def =. a_def, horizontal_separator
 a_def =. a_def, 'NB. ====  (1/4) name of application =======', CRLF
 a_def =. a_def, 'NB./*/APP_FOLDER_NAME/', TEXTBOX_90_VALUE, CRLF, CRLF

 a_def =. a_def, horizontal_separator
 a_def =. a_def, 'NB. ====  (2/4) design of HTML doc  =======', CRLF
 a_def =. a_def, 'NB./*/HTML_TITLE/', TEXTBOX_91_VALUE, CRLF
 a_def =. a_def, 'NB./*/HTML_REMARK/', TEXTBOX_92_VALUE, CRLF, CRLF

 a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF

 if. CHECKBOX_00_VALUE -: 'textbox_00' do.
    a_def =. a_def, 'NB./*/TEXTBOX/00/', DROPDOWN_00_VALUE, '/', TEXTBOX_00_VALUE, '/', TEXTBOX_01_VALUE, '/', TEXTBOX_02_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_10_VALUE -: 'textbox_01' do.
    a_def =. a_def, 'NB./*/TEXTBOX/01/', DROPDOWN_10_VALUE, '/', TEXTBOX_10_VALUE, '/', TEXTBOX_11_VALUE, '/', TEXTBOX_12_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_20_VALUE -: 'textbox_02' do.
    a_def =. a_def, 'NB./*/TEXTBOX/02/', DROPDOWN_20_VALUE, '/', TEXTBOX_20_VALUE, '/', TEXTBOX_21_VALUE, '/', TEXTBOX_22_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_30_VALUE -: 'textarea_00' do.
    a_def =. a_def,  'NB./*/TEXTAREA/00/', DROPDOWN_30_VALUE, '/', TEXTBOX_30_VALUE, '/', TEXTBOX_31_VALUE, '/', TEXTBOX_32_VALUE, '/', TEXTBOX_33_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_40_VALUE -: 'checkbox_00' do.
    a_def =. a_def,  'NB./*/CHECKBOX/00/', DROPDOWN_40_VALUE, '/', TEXTBOX_40_VALUE, '/', TEXTBOX_41_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_50_VALUE -: 'checkbox_01' do.
    a_def =. a_def,  'NB./*/CHECKBOX/01/', DROPDOWN_50_VALUE, '/', TEXTBOX_50_VALUE, '/', TEXTBOX_51_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_60_VALUE -: 'dropdown_00' do.
    a_def =. a_def,  'NB./*/DROPDOWN/00/', DROPDOWN_60_VALUE, '/', TEXTBOX_60_VALUE, '/', TEXTBOX_61_VALUE, '+', TEXTBOX_62_VALUE, '/', TEXTBOX_63_VALUE, '+', TEXTBOX_64_VALUE, '/', TEXTBOX_65_VALUE, '+', TEXTBOX_66_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_70_VALUE -: 'checklist_00' do.
    a_def =. a_def,  'NB./*/CHECKLIST/00/', DROPDOWN_70_VALUE, '/', TEXTBOX_70_VALUE, '/', TEXTBOX_71_VALUE, '/', TEXTBOX_72_VALUE, '+', TEXTBOX_73_VALUE, '/', TEXTBOX_74_VALUE, '+', TEXTBOX_75_VALUE, '/', TEXTBOX_76_VALUE, '+', TEXTBOX_77_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 if. CHECKBOX_80_VALUE -: 'radiobutton_00' do.
    a_def =. a_def,  'NB./*/RADIOBUTTON/00/', DROPDOWN_80_VALUE, '/', TEXTBOX_80_VALUE, '/', TEXTBOX_81_VALUE, '+', TEXTBOX_82_VALUE, '/', TEXTBOX_83_VALUE, '+', TEXTBOX_84_VALUE, '/', TEXTBOX_85_VALUE, '+', TEXTBOX_86_VALUE, CRLF
    a_def =. a_def, 'NB./*/HORIZONTALLINE', CRLF
 end.

 a_def =. a_def, horizontal_separator
 
 a_def =. a_def, 'NB. ====  (3/4) description of J function  =======', CRLF
 a_def =. a_def, TEXTAREA_00_VALUE, CRLF, CRLF
 
 a_def =. a_def, horizontal_separator
 a_def =. a_def, 'NB. ====  (4/4) description of your job based on POSTed data as argument of J function =======',CRLF
 a_def =. a_def, 'YOUR_JOB =: 3 : 0', CRLF
 a_def =. a_def, 'a_collection =. monitor_entry_ID_values 0 NB.extraction of POSTed data', CRLF
 a_def =. a_def, 'reply_msg =. ', '''', 'operation done without error','''', CRLF
 a_def =. a_def, 'reply_msg =. reply_msg, CRLF, CRLF', CRLF
 a_def =. a_def, 'reply_msg =. reply_msg, a_collection', CRLF
 a_def =. a_def, 'try.', ' NB. -----', CRLF
 a_def =. a_def, TEXTAREA_01_VALUE, CRLF, CRLF
 a_def =. a_def, 'catch.', ' NB. -----', CRLF
 a_def =. a_def, 'reply_msg =. ', '''','error occurred during the operation','''', CRLF
 a_def =. a_def, 'end.', ' NB. -----', CRLF
 a_def =. a_def, 'reply_msg', CRLF
 a_def =. a_def, ')', CRLF
 a_def =. a_def, 'NB. end of creation', CRLF

a_def wtf 'app_plan_created_with_posted_info.ijs'
1
)

NB. *===================================================================================================
input_port_number_for_socket =: 3 : 0

PORT_FOR_SERVER =: rff 'port_selected.txt'

NB. print '通信に使用するポート番号（整数）を入力して下さい '
    print 'specify port number for communication( integer value )'
NB. print '現在の ', PORT_FOR_SERVER, ' でよければ、数字は入力せすEnter Keyで次に進んで下さい '
    print 'Current port: ', PORT_FOR_SERVER, ' if this is OK then just hit enter to proceed'

your_choice =. keyin 0
if. (your_choice -: '') do.
   NB. print '現在の ', PORT_FOR_SERVER, ' を了承'
       print 'current port: ', PORT_FOR_SERVER, ' is accepted'
else.
   b_num =. check_hankaku_number your_choice
   if. b_num >0 do.
     PORT_FOR_SERVER =: your_choice
     PORT_FOR_SERVER wtf 'port_selected.txt'
   else.
     NB. print '入力値が半角数字でありません'
         print 'input number is not ascii. two byte number is not allowed.'
   end.
end.
1
)

activate_menu_2 =: 3 : 0
NB. the following is the copy of menu2 procedure....

         NB. check appropriateness of a given application_web_from_plan2_jconsole.ijs
	 NB. extract def lines from the file and save them to 'all_def_lines.txt'
         NB. APP_PLAN =: rff 'web_form_app_definition_file.ijs'
	 NB. all_def_lines_for_html_doc =. extract_web_app_def_lines APP_PLAN
	 NB. all_def_lines_for_html_doc wtf 'all_def_lines_jconsole.ijs'

         NB.dummy =. extract_planed_app_name_folder 0
	 a_result =. extract_planned_app_name_folder_without_space 0
	 print 'extract_planned_app_name_folder_without_space 0 .. executed'
         print 'APP_DEF_FILE_READY : ', ":APP_DEF_FILE_READY
	 
	 if. APP_DEF_FILE_READY = 1 do.
            NB. check form control def line format appropriateness here if CHECK_RESULT = 1, then proceed
	    NB. otherwise go back to menu
	    check_def_line_format APP_PLAN
	    print 'check_def_line_format result: CHECK_RESULT = ', ":CHECK_RESULT
	    if. CHECK_RESULT = 1 do.
               make_new_web_form_app_for_jconsole 0
	    else.
               print 'There is web control format error', CRLF
	       print 'correct error(s) and retry', CRLF
            end.
	 else.
            NB. print '作業領域に定義ファイルはありません。既存アプリ選択か新規作成が必要です。'
	    NB. print2 'no app definition file is found. please prepare it'
	        print2 CRLF, a_result, CRLF
            NB. print CRLF, 'enter keyでmenuに戻ります'
                print2 CRLF, 'enter key to go back to menu'
	   dummy =. keyin 8
	 end.
)

NB. ---------------------------------------
NB. --- main script for web form server ---
NB. ---------------------------------------

NB. *===================================================================================================
jserver_menu =: 3 : 0  NB. menu driven jserver operation

NB. store PORT_FOR_SERVER to 'port_selected.txt'
(":PORT_FOR_SERVER) wtf  'port_selected.txt'

RESPONSE_IMG_TYP =: 'BMP'  NB. This is default image type
IFRAME_SIZE_W =: '100'     NB. default iframe width  100, but can be changed by each app
IFRAME_SIZE_H =: '100'     NB. default iframe height 100, but can be changed by each app
IFRAME_BORDER =: '1'       NB. default iframe border yes

prepare_boxed_two_char_digit_00_to_98 0

while. 1 do.

    RESPONSE_IMG_FLG =: 0  NB. this flag is always nil but app can set true for it during its execution
                           NB. IFRAME_SIZE_W, IFRAME_SIZE_H are also redefined within app 
    menu_code_selected =. disp_menu 0
    ascii_code_of_menu_code_selected =. a. i. menu_code_selected
    selection_in_ascii =. ascii_code_of_menu_code_selected
    
    if. selection_in_ascii = a. i. '1'  do.
         list_current_app 0
         NB. print CRLF, 'enter keyでmenuに戻ります'
	     print2 CRLF, 'enter key to go back to menu'
	     dummy =. keyin 8
    end.

    if. selection_in_ascii = a. i. '2'  do.
         NB. check appropriateness of a given application_web_from_plan2_jconsole.ijs
	 NB. extract def lines from the file and save them to 'all_def_lines.txt'
         NB. APP_PLAN =: rff 'web_form_app_definition_file.ijs'
	 NB. all_def_lines_for_html_doc =. extract_web_app_def_lines APP_PLAN
	 NB. all_def_lines_for_html_doc wtf 'all_def_lines_jconsole.ijs'

         NB.dummy =. extract_planed_app_name_folder 0
	 a_result =. extract_planned_app_name_folder_without_space 0
	 print 'extract_planned_app_name_folder_without_space 0 .. executed'
         print 'APP_DEF_FILE_READY : ', ":APP_DEF_FILE_READY
	 
	 if. APP_DEF_FILE_READY = 1 do.
            NB. check form control def line format appropriateness here if CHECK_RESULT = 1, then proceed
	    NB. otherwise go back to menu
	    check_def_line_format APP_PLAN
	    print 'check_def_line_format result: CHECK_RESULT = ', ":CHECK_RESULT
	    if. CHECK_RESULT = 1 do.
               make_new_web_form_app_for_jconsole 0
	    else.
               print 'There is web control format error', CRLF
	       print 'correct error(s) and retry', CRLF
            end.
	 else.
            NB. print '作業領域に定義ファイルはありません。既存アプリ選択か新規作成が必要です。'
	    NB. print2 'no app definition file is found. please prepare it'
	        print2 CRLF, a_result, CRLF
            NB. print CRLF, 'enter keyでmenuに戻ります'
                print2 CRLF, 'enter key to go back to menu'
	   dummy =. keyin 8
	 end.
    end.

    if. (selection_in_ascii = a. i. 'R') +.  (selection_in_ascii = a. i. 'r')  do.
       NB. print CRLF, '現在保存されている定義ファイルのアプリ名を確認します。'
       NB. print CRLF, 'enter keyでmenuに戻ります'
       NB. dummy =. keyin 8

       NB. print CRLF, '登録済アプリの定義ファイルを改訂用に作業ディレクトリに複写します。改訂は外部エディタで行って下さい。'
           print2 CRLF, 'def file from registered application will be copied. please edit it with your favourite editor.'
       NB. list_current_app_without_app_exec 0
       app_reload_question 0
       NB. revision_run ''
       NB. print CRLF, 'enter keyでmenuに戻ります'
       NB. dummy =. keyin 8
       NB. print CRLF, 'enter keyでmenuに戻ります'
           print2 CRLF, 'enter key to go back to menu'
       dummy =. keyin 8
    end.
    
    if. (selection_in_ascii = a. i. 'N') +.  (selection_in_ascii = a. i. 'n')  do.
       NB. print CRLF, '定義ファイル作成用サーバーアプリで作成したファイルをメニュー２で使えるように登録します。'
       NB. print       '改訂は外部エディタで行って下さい。'
           print2 CRLF, 'newly created app def file will be copied to working region. please edit it with your favourite editor'
       register_newly_created_app_def_file_to_working_dir 0
       NB. revision_run ''
       NB. print CRLF, 'enter keyでmenuに戻ります'
           print2 CRLF, 'enter key to go back to menu'
       dummy =. keyin 8
    end.
    
    if. (selection_in_ascii = a. i. 'E') +.  (selection_in_ascii = a. i. 'e')  do.
       if. YOUR_OS -: 'mac' do.
          try.
            2!:0 'ls /usr/bin | grep emacs'
            a_file =. INSTALL_DIR, SUB_DIR, 'web_form_app_definition_file.ijs'
            a_cmd =. 'emacs ', a_file
            a_cmd_2 =. '2!:0 ','''',a_cmd, ''''
            ".a_cmd_2
            print 'When finishing, type enter to go back to menu'
            dummy =. keyin 0
            goto_skipped.
          catch.
            print CRLF, 'emacs NOT FOUND!! in /usr/bin ', CRLF
            print 'hit enter to check port dir /opt/local/bin/emacs'
            dummy =. keyin 0
          end.
          try.
            2!:0 'ls /opt/local/bin | grep emacs'
            a_file =. INSTALL_DIR, SUB_DIR, 'web_form_app_definition_file.ijs'
            a_cmd =. 'emacs ', a_file
            a_cmd_2 =. '2!:0 ','''',a_cmd, ''''
            ".a_cmd_2
            print 'When finishing, type enter to go back to menu'
            dummy =. keyin 0
            goto_skipped.
          catch.
            print CRLF, 'emacs NOT FOUND!! You may install emacs.', CRLF
            print 'hit enter to check nano editor availability'
            dummy =. keyin 0
          end.
          try.
            2!:0 'ls /usr/bin | grep nano'
            a_file =. INSTALL_DIR, SUB_DIR, 'web_form_app_definition_file.ijs'
            a_cmd =. 'nano ', a_file, LF
            a_cmd wtf INSTALL_DIR, '/startEditor.sh'
            print 'Open another terminal and issue the following command'
	    if. '/mnt/c' position_of_str_x_in_y_str INSTALL_DIR do.
               print 'sh /mnt/c/making/startEditor.sh',CRLF
	    else.
               print 'sh $HOME/making/startEditor.sh',CRLF
	    end.
            print 'When finishing definition file revision and exit nano editor, type enter to go back to menu'
            dummy =. keyin 0
          catch.
            a_file2 =. INSTALL_DIR, SUB_DIR, 'web_form_app_definition_file.ijs'
            print CRLF, 'nano editor NOT FOUND!! please install nano editor.', CRLF
            print CRLF, 'Or you may edit the file: ', a_file2, CRLF, 'with your favourite text editor for a revision.', CRLF
            print CRLF, 'On finishing a revision and exit the editor, type enter to go back to menu', CRLF
            dummy =. keyin 0
          end.
        end.
        label_skipped.
        if. YOUR_OS -: 'windows' do.
          a_file =. 'c:\making\jconsole\jsocket\', 'web_form_app_definition_file.ijs'
          a_cmd =. 'notepad.exe ', a_file, CRLF
          a_cmd wtf 'c:\making\startEditor.bat'
          print  CRLF
          print 'Open windows command prompt by cmd.exe and issue the following command'
          print 'c:\making\startEditor.bat',CRLF
          print 'When finishing, type enter to go back to menu'
          dummy =. keyin 0
         end. 
    end.
    
    if. (selection_in_ascii = a. i. 'I') +.  (selection_in_ascii = a. i. 'i')  do.
       NB. if. RESPONSE_IMG_FLG = 0 do. RESPONSE_IMG_FLG =: 1 else. RESPONSE_IMG_FLG =: 0 end.  NB. toggle
       NB. print CRLF, 'response image flag is set  : ', (":RESPONSE_IMG_FLG), CRLF
       NB. print CRLF, 'response image type is set  : ', RESPONSE_IMG_TYP, CRLF
       NB. print CRLF, 'response image frame width  : ', IFRAME_SIZE_W, CRLF
       NB. print CRLF, 'response image frame height : ', IFRAME_SIZE_H, CRLF
       NB. print 'hit enter key to go back to menu'
       NB. this is hidden menu command for test use...
       NB. dummy =. keyin 8
    end.
    
    if. (selection_in_ascii = a. i. 'T') +.  (selection_in_ascii = a. i. 't')  do.
       NB. if. RESPONSE_IMG_TYP -: 'BMP' do. RESPONSE_IMG_TYP =: 'PNG' elseif. RESPONSE_IMG_TYP -: 'PNG' do. RESPONSE_IMG_TYP =: 'BMP' end.
       NB. print CRLF, 'response image flag is set  : ', (":RESPONSE_IMG_FLG), CRLF
       NB. print CRLF, 'response image type is set  : ', RESPONSE_IMG_TYP, CRLF
       NB. print CRLF, 'response image frame width  : ', IFRAME_SIZE_W, CRLF
       NB. print CRLF, 'response image frame height : ', IFRAME_SIZE_H, CRLF
       NB. print 'hit enter key to go back to menu'
       NB. this is hidden menu command for test use...
       NB. dummy =. keyin 8
    end.
    
    NB.if. (selection_in_ascii = a. i. 'W') +.  (selection_in_ascii = a. i. 'w')  do.
    if. (selection_in_ascii = a. i. 'X') +.  (selection_in_ascii = a. i. 'x')  do.
       NB. print CRLF, 'input new width for IFRAME'
       NB. a_num =. keyin 8
       NB. b_num =. check_hankaku_number a_num
       NB. if. b_num > 0 do. IFRAME_SIZE_W =: ":b_num end.
       NB. IFRAME_SIZE_W =: keyin 8
       NB. print2 CRLF, 'enter key to go back to menu'
       NB. dummy =. keyin 8
    end.
    
    if. (selection_in_ascii = a. i. 'W') +.  (selection_in_ascii = a. i. 'w')  do.
    NB. if. (selection_in_ascii = a. i. 'X') +.  (selection_in_ascii = a. i. 'x')  do.
       NB. print CRLF, 'input new width for IFRAME'
       NB. a_num =. keyin 8
       NB. b_num =. check_hankaku_number a_num
       NB. if. b_num > 0 do. IFRAME_SIZE_W =: ":b_num end.
       NB. IFRAME_SIZE_W =: keyin 8
       NB. print2 CRLF, 'enter key to go back to menu'
       NB. dummy =. keyin 8
    end.

    if. (selection_in_ascii = a. i. 'H') +.  (selection_in_ascii = a. i. 'h')  do.
       NB. print CRLF, 'input new height for IFRAME'
       NB. a_num =. keyin 8
       NB. b_num =. check_hankaku_number a_num
       NB. if. b_num > 0 do. IFRAME_SIZE_H =: ":b_num end.
       NB. IFRAME_SIZE_H =: keyin 8
       NB. print2 CRLF, 'enter key to go back to menu'
       NB. dummy =. keyin 8
    end.
    
    if. (selection_in_ascii = a. i. 'D') +.  (selection_in_ascii = a. i. 'd')  do.
       NB. print CRLF, '不要になったアプリケーションを削除します。'
           print2 CRLF, 'application deletion job'
       NB. list_current_app_without_app_exec 0
       app_delete_question 0
       NB. print CRLF, 'enter keyでmenuに戻ります'
       NB. dummy =. keyin 8
       NB. print CRLF, 'enter keyでmenuに戻ります'
           print2 CRLF, 'enter key to go back to menu'
       dummy =. keyin 8
    end.

    if. (selection_in_ascii = a. i. 'v') +.  (selection_in_ascii = a. i. 'V')  do.
       print2 CRLF, '-----------------------------------------------------'
       print2 CRLF, 'version memo of jsocket web form server manager menu'
       print2 CRLF, '-----------------------------------------------------'
       print2 CRLF, '  ver 0.1    (the first version)'
       print2 CRLF, '  ver 0.1.1  (typos have been corrected)'
       print2 CRLF, '-----------------------------------------------------'
       print2 CRLF, 'enter key to go back to menu'
       dummy =. keyin 8
    end.



    if. (selection_in_ascii = a. i. 'C') +.  (selection_in_ascii = a. i. 'c')  do.
           print2 CRLF, 'issue making def file web form app and issue menu 2 on returning'

           issue_making_def_file_web_app_and_activate_menu_2 0
	   
           print2 CRLF, 'newly created app def file will be copied to working region. please edit it with your favourite editor'
           register_newly_created_app_def_file_to_working_dir 0

           activate_menu_2 0
	   
       NB. print CRLF, 'enter keyでmenuに戻ります'
       NB. dummy =. keyin 8
       NB. print CRLF, 'enter keyでmenuに戻ります'
           print2 CRLF, 'enter key to go back to menu'
       dummy =. keyin 8
    end.

    if. (selection_in_ascii = a. i. 'Q') +.  (selection_in_ascii = a. i. 'q')  do.
       NB. print CRLF, ' 管理メニューを終了します'
           print CRLF, ' quit server menu'
       break.
    end.
end.

print CRLF, ' you have now exited from the main menu'
print 'To resume system, enter command:'
print '   resume 0'
1
)

NB. ====================================================================================================
NB. alternative definitions
resume                               =: jserver_menu
start_web_form_server_for_j_function =: jserver_menu

NB.  LocalWords:  jsocket jconsole ijs trans Yuji Suda UTF exe mac qt jconsoles JIS
NB.  LocalWords:  coinsert VER str usr dir wtf rff lineNo Ln CRLF aLine FLG cmd en
NB.  LocalWords:  ja app def src rmapp flnum cnt rm rmdir entryID html textbox num
NB.  LocalWords:  textarea RADIOBUTTON radiobutton CHECKBOX checkbox DROPDOWN disp
NB.  LocalWords:  dropdown ver behavior nano keyin txt curApp awk addNR systemApp
NB.  LocalWords:  HITLINE chr aFoo tmp br HORIZONTALLINE hr preFix col cols webForm
NB.  LocalWords:  radiobuttons chekclist apps jserver mkdir initialize bmp img png
NB.  LocalWords:  hankaku zenkaku ascii POSTed msg TYP IFRAME iframe grep LF elseif
NB.  LocalWords:  artEditor
