NB. support_tools_jconsole.ijs
NB. support_tools_jconsole_2023_11_13.ijs

NB. Yuji Suda
NB. g.ysuda@gmail.com
NB. encoding code: UTF-8

NB. jsocket_web_serverで使われる補助関数一式

load INSTALL_DIR, '/basic_system_tools.ijs'

NB. ====================================================================================================
line_count_check_of_multi_line_str_y =: 3 : 0
v =. y
countLF   =. +/ LF E. v
countCRLF =. +/ CRLF E. v
if. countCRLF = 0 do.
  print CRLF, 'this is mac multiline str'
  print CRLF, 'and LF -> CRLF replacement will proceed.'
  y2 =. replace_LF_with_CRLF_all v
  y2
  return.
end.
NB.if. countLF = 0 do.
NB.  print CRLF, 'this is mac multiline str'
NB.  print CRLF, 'and LF -> CRLF replacement will proceed.'
NB.  y2 =. replace_LF_with_CRLF_all
NB.  return
NB.end.
v
)

NB. ====================================================================================================
take_one_line =: 3 : 0  NB. take one line from string
v =. y
position_of_CRLF =. ((CRLF E. v) i. 1)
one_line =. position_of_CRLF {. v
NB. v =. 2}.v NB. remove CRLF
NB. one_line
)

NB. ====================================================================================================
take_first_word =: 3 : 0 NB. drop 1st word from a line
v =. y
position_of_space =. ((' ' E. v) i. 1)
first_word =. position_of_space {. v
)

NB. ====================================================================================================
take_first_word_slash =: 3 : 0 NB. drop 1st word from a line
v =. y
position_of_space =. (('/' E. v) i. 1)
first_word =. position_of_space {. v
)

NB. ====================================================================================================
take_first_word_plus =: 3 : 0 NB. drop 1st word from a line
v =. y
position_of_space =. (('+' E. v) i. 1)
first_word =. position_of_space {. v
)

NB. ====================================================================================================
take_first_word_with_sep_chr_x =: 4 : 0 NB. drop 1st word from a line
v =. y
position_of_space =. ((x E. v) i. 1)
first_word =. position_of_space {. v
)

NB. ====================================================================================================
count_items_with_separator_chr_x =: 4 : 0
1 +  +/ x E. y
)

NB. ====================================================================================================
number_of_items_separated_with_x_str_in_y_str =: 4 : 0
1 +  +/ (x E. y)  NB. x x_pos_y y
)

NB. ====================================================================================================
NB. alternative definition of above
num_of_items =: number_of_items_separated_with_x_str_in_y_str NB. short form

NB. ====================================================================================================
pick_up_x_th_item_from_slash_separated_str_y =: 4 : 0
number_of_items =. '/' count_items_with_separator_chr_x y
v =. y
cnt =. 0
hit_item =. ''
while. cnt < number_of_items do.
  anItem =. '/' take_first_word_with_sep_chr_x v
  if. cnt = x do.
    NB. print (3j0":cnt), ' ', anItem
    print anItem
    hit_item =. anItem
    return.
  end.
  v =. (1 + $anItem) }. v
  cnt =. 1 +  cnt
end.
hit_item NB. this is item hit
)

NB. ====================================================================================================
pick_up_x_th_item_from_plus_separated_str_y =: 4 : 0
number_of_items =. '+' count_items_with_separator_chr_x y
v =. y
cnt =. 0
while. cnt < number_of_items do.
  anItem =. '+' take_first_word_with_sep_chr_x v
  if. cnt = x do.
      print (3j0":cnt), ' ', anItem
      hit_item =. anItem
      return.
  end.
  v =. (1 + $anItem) }. v
  cnt =. 1 +  cnt
end.
anItem NB. this is item hit
)

NB. ====================================================================================================
pick_up_x_th_item_from_space_separated_str_y =: 4 : 0
NB. index starts with zero as the first item
number_of_items =. ' ' count_items_with_separator_chr_x y
v =. y
cnt =. 0
while. cnt < number_of_items do.
  anItem =. ' ' take_first_word_with_sep_chr_x v
  if. cnt = x do.
      print (3j0":cnt), ' ', anItem
      hit_item =. anItem
      return.
  end.
  v =. (1 + $anItem) }. v
  cnt =. 1 +  cnt
end.
anItem NB. this is item hit
)

NB. ====================================================================================================
pick_up_items_all_with_separator_chr_x =: 4 : 0
number_of_items =. x count_items_with_separator_chr_x y
v =. y
cnt =. 0
while. cnt < number_of_items do.
  anItem =. x take_first_word_with_sep_chr_x v
  print (3j0":cnt), ' ', anItem
  v =. (1 + $anItem) }. v
  cnt =. 1 +  cnt
end.
''
)

NB. ====================================================================================================
pick_up_items_all_with_separator_chr_2x =: 4 : 0
v =. y
firstChr =. 0 { x,' '  NB. secure 2nd chr
secondChr =. 1 { x,' ' NB. secure 2nd chr
number_of_items =. firstChr count_items_with_separator_chr_x v
cnt =. 0
while. cnt < number_of_items do.
  anItem =. firstChr take_first_word_with_sep_chr_x v
  print (3j0":cnt), ' ', anItem
  if. 0 < secondChr count_items_with_separator_chr_x anItem do.
    secondChr pick_up_items_all_with_separator_chr_x anItem
  end.
  v =. (1 + $anItem) }. v
  cnt =. 1 +  cnt
end.
''
)

NB. ====================================================================================================
view_x_th_line_in_y_multiline =: 4 : 0
v =. y
lineNo =. 0
total_Ln =. +/CRLF E. y
NB.for. (i. (+/ CRLF E. y)) do.
while. lineNo < total_Ln do.
 aLine =. take_one_line v
 NB. print (3j0 ":lineNo),' ', aLine  NB. , CRLF  NB. monitor taken line
 if. lineNo = x do.
     NB.print aLine
     break.
 end.
 v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
 lineNo =. 1 + lineNo
end.
aLine
)

NB. ====================================================================================================
check_full_line_match_with_x_in_y_CRLF_separated_str =: 4 : 0
matched_flg =. 0
u =. x
v =. y
lineNo =. 0
total_Ln =. +/CRLF E. y
NB.for. (i. (+/ CRLF E. y)) do.
while. lineNo < total_Ln do.
 aLine =. take_one_line v
 NB. print (3j0 ":lineNo),' ', aLine  NB. , CRLF  NB. monitor taken line
 NB. print u, ' ? ', aLine  NB. , CRLF  NB. monitor taken line
 if. u -: aLine do.
   print '----> !!! matched'
   matched_flg =. 1
 else.
   NB. print '----> not matched'
 end.
 v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
 lineNo =. 1 + lineNo
end.
matched_flg
)

NB. ====================================================================================================
view_one_line_all =: 3 : 0 NB. take all lines from string
v =. y
lineNo =. 0
total_Ln =. +/CRLF E. y
NB.for. (i. (+/ CRLF E. y)) do.
while. lineNo < total_Ln do.
 aLine =. take_one_line v
 print (3j0 ":lineNo),' ', aLine  NB. , CRLF  NB. monitor taken line
 v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
 lineNo =. 1 + lineNo
end.
''
)

NB. ====================================================================================================
extract_specific_line_with_x_str =: 4 : 0
v =. y
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print aLine
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
''
)

NB. ====================================================================================================
exclude_specific_line_with_x_str_and_return_result =: 4 : 0
v =. y
result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print 'exlude this line - ', aLine
      NB.result =. result, aLine, CRLF
 else.
      print 'leave  this line * ', aLine
      result =. result, aLine, CRLF
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
result
)

NB. ====================================================================================================
extract_specific_line_with_x_str_and_return_result =: 4 : 0
v =. y
result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
    NB.if. x -: ($x){. aLine do.
      print aLine
      result =. result, aLine, CRLF
    NB.end.
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
result
)

NB. ====================================================================================================
extract_specific_line_with_x_str_and_return_result_org =: 4 : 0
v =. y
result =. ''
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print aLine
      result =. result, aLine, CRLF
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
result
)

NB. ====================================================================================================
extract_specific_first_line_with_x_str =: 4 : 0
v =. y
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. ((x E. aLine) i. 1) < $aLine do.
      print aLine
      break.
 end.
 v =. (2 + $aLine) }. v NB. drop the line for next line
end.
aLine
)

NB. ====================================================================================================
extract_func_name_in_ijs =: 3 : 0 NB. take all function lines
v =. y
for. (i. (+/ CRLF E. y)) do.
 aLine =. take_one_line v
 if. (('=: 3 : 0' E. aLine) i. 1) < $aLine do.
   if. (('NB.' E. aLine) i. 1) < $aLine do.
      print take_first_word aLine
   end.
 end.
 if. (('=: 4 : 0' E. aLine) i. 1) < $aLine do.
   if. (('NB.' E. aLine) i. 1) < $aLine do.
      print take_first_word aLine
   end.
 end.
 NB. print aLine  NB. , CRLF  NB. monitor taken line
 v =. (2 + $ aLine) }. v  NB. drop line + CRLF(2 byte)
end.
)

NB. ====================================================================================================
NB. vector あるいは matrix 数値データをテキストファイルに保存する
NB. array l m n には未対応
save_matrix_number_data_as_text_file =: 4 : 0
NB. 文字化したmatrixの形を調べる
NB. x argument to char
xchar =. ":x
shape_of_xchar =. $ xchar
NB. shape_of_xchar is 0 if x is nil

NB. 形の要素個数を調べる
s1 =. $ shape_of_xchar

NB. もし shape_of_xchar  が 0であれば、nilデータなので、'' を保存
NB. もし $ s1 が 1でかつ、shape_of_xcharがゼロでなければ vector なので
NB. そのまま xchar を y （ファイル名 'buffer.txt'など）に保存
NB. 2であれば matrixなので行単位で行末にCRLFを付加して保存する
NB. 行数は shape_of_xchar の第一要素である

NB. 保存先ファイルの初期化
'' wtf y

if. shape_of_xchar = 0 do.
NB.'エラーなく実行され、結果としてnilが戻されました' append_it y
   'execution is finished without error, result is nil' append_it y
   print 'nil data is saved ', CRLF
end.
if. ((s1 = 1) *. ( ($ shape_of_xchar) = 1))   do.
   NB. vecotr data
   (xchar, CRLF) append_it y
   print 'saved data', CRLF, xchar
end.
if. s1 = 2 do.
   row =. 0
   row_max =. 0 { shape_of_xchar
   while. row < row_max do.
       ((row { xchar), CRLF) append_it y
       print 'saving ... ', row { xchar
       row =. row + 1
   end.
end.

NB. print '保存処理終了'
    print 'saving to file done'
NB. print 'ファイル名 ', y, ' に保存しました。'
    print 'To ', y
NB. print '保存されたテキストは以下の通りです。'
    print 'content of file is as follows'
    print (rff y), CRLF
1
)

NB. ====================================================================================================
NB. vector  matrix array数値データをテキストファイルに保存する
NB. array l m n 
save_array_number_data_as_text_file =: 4 : 0
NB. 文字化したarrayの形を調べる
NB. x argument to char
xchar =. ":x
shape_of_xchar =. $ xchar
NB. shape_of_xchar is 0 if x is nil

NB. 形の要素個数を調べる
s1 =. $ shape_of_xchar

NB. もし shape_of_xchar  が 0であれば、nilデータなので、'' を保存
NB. もし $ s1 が 1でかつ、shape_of_xcharがゼロでなければ vector なので
NB. そのまま xchar を y （ファイル名 'buffer.txt'など）に保存
NB. 2であれば matrixなので行単位で行末にCRLFを付加して保存する
NB. 行数は shape_of_xchar の第一要素である
NB. 3であれば arrayなのでmatrix単位でループさせる

NB. 保存先ファイルの初期化
'' wtf y

if. shape_of_xchar = 0 do.
NB.'エラーなく実行され、結果としてnilが戻されました' append_it y
   'execution is finished without error, result is nil' append_it y
   print 'nil data is saved ', CRLF
end.
if. ((s1 = 1) *. ( ($ shape_of_xchar) = 1))   do.
   NB. vecotr data
   (xchar, CRLF) append_it y
   print 'saved data', CRLF, xchar
end.
if. s1 = 2 do.
   row =. 0
   row_max =. 0 { shape_of_xchar
   while. row < row_max do.
       ((row { xchar), CRLF) append_it y
       print 'saving ... ', row { xchar
       row =. row + 1
   end.
end.
if. s1 = 3 do.
   table =. 0
   table_max =. 0 { shape_of_xchar
   while. table < table_max do.
      row =. 0
      row_max =. 1 { shape_of_xchar
      while. row < row_max do.
          ((row { table { xchar), CRLF) append_it y
	  print 'saving ..', row { table { xchar
	  row =. row + 1
      end.
      CRLF append_it y
      table =. table + 1
   end.
end.

NB. print '保存処理終了'
    print 'file saving has been completed'
NB. print 'ファイル名 ', y, ' に保存しました。'
    print 'To ', y
NB. print '保存されたテキストは以下の通りです。'
    print 'content of file is as follows'
    print (rff y), CRLF
1
)

NB. ====================================================================================================
NB. alternative definition
NB. arrayデータをテキストファイルに保存する( CRLF end of line added text file)
save_array_data_as_CRLF_ended_text_file =: save_array_number_data_as_text_file

NB. ====================================================================================================
NB. 文字列中の半角プラスをスペースへ変換する関数 
NB. HTMLフォームから送信された文字列中の半角スペースが半角文字 + になって送られて
NB. 来るため、それを半角スペースに戻す必要がある 
NB. 例えば '35.6 40' という文字列は '35.6+40'となってサーバー
NB. に届く為、文字列の連結で使われている + を半角スペースに戻す為に必要 

plus_to_space =: 3 : 0
' ' (y i. '+')}y
)

NB. ====================================================================================================
plus_to_space_all =: 3 : 0
v =. y
for. (i. (+/'+' E. y)) do.
   v =. plus_to_space v
end.
)

NB. ====================================================================================================
NB. 文字列中の半角ハイフンをアンダーバーへ変換
NB. ブラウザから送られる負の数はハイフンで表記されているので
NB. Jで処理するためにハイフンをアンダーバーに変換する

hifen_to_underbar =: 3 : 0
'_' (y i. '-')}y
)

NB. ====================================================================================================
hifen_to_underbar_all =: 3 : 0
v =. y
for. (i. (+/'-' E. y)) do.
   v =. hifen_to_underbar v
end.
)

NB. ====================================================================================================
NB. 文字列中の半角アンダーバーをハイフンへ変換
NB. Jの負の数を示すアンダーバーをブラウザでマイナス記号として表示するために
NB. ハイフンへ変換する

underbar_to_hifen =: 3 : 0
'-' (y i. '_')}y
)

NB. ====================================================================================================
underbar_to_hifen_all =: 3 : 0
v =. y
for. (i. (+/'_' E. y)) do.
   v =. underbar_to_hifen v
end.
)

NB. ====================================================================================================
NB. CRLF -> space ...CRLF ended multi line to one line , for use jturtle cmd lines
replace_CRLF_with_space =: 3 : 0
v =. y  NB.一旦別変数vに代入
NB. CRLFの出現位置を求め、l に代入
l =. (CRLF E. v) i. 1

NB. CRLFまでの文字列を取り、残った文字列から
NB. CRLFの2バイトを落とし、最初に取った文字列、' '、残りの文字列
NB. を連結して置換完了
(l {. v), ' ', 2 }. l }.v
)

NB. ====================================================================================================
replace_CRLF_with_space_all =: 3 : 0
v =. y
for. (i. (+/ CRLF E. y)) do.
   v =. replace_CRLF_with_space v
end.
)

NB. ====================================================================================================
replace_LF_with_CRLF =: 3 : 0
v =. y  NB.一旦別変数vに代入
NB. LFの出現位置を求め、posに代入
pos =. (LF E. v) i. 1

NB. LFまでの文字列を取り、残った文字列から
NB. LFの1バイトを落とし、最初に取った文字列、CRLF、残りの文字列
NB. を連結して置換完了
(pos {. v), CRLF, 1 }. pos }.v
)

NB. ====================================================================================================
replace_LF_with_CRLF_all =: 3 : 0
v =. y
total_LF =. num_of_LF_lines_in_y_str v
total_LF =. total_LF - 1
cnt =. 0
new_all_with_CRLF =. ''
while. cnt < total_LF do. 
   a_line =. take_LF_one_line_from_lines v
   NB.print 'a_line code = ', ": a.i. a_line
   NB. add it to new_all_with_CRLF
   if. 10 = a. i. a_line do. 
     new_all_with_CRLF =. new_all_with_CRLF, CRLF   NB., CR NB.CRLF
   else.
     new_all_with_CRLF =. new_all_with_CRLF, (_1}.a_line), CRLF
   end.
   NB. update v with dropping a_line
   v =. (($a_line) ) }. v
   NB.print 'remaining ---> ', ": a. i. v
   NB.if. 1 < ($a_line) do. v =. 1}.v end.
   NB.print 'remaining ---> ', ": a. i. v
   NB. and repeat 
   cnt =. cnt + 1
end.
new_all_with_CRLF
)

NB. ====================================================================================================
NB. 改行コードの変換
NB. HTMLフォームの複数行のテキストデータは末尾改行コードが '%0D%0A' という
NB. 文字列(6バイト)に変換されてサーバーへ送られてくる為、本来の CRLFへ戻す為に必要

replace_newline_code =: 3 : 0
v =. y  NB.一旦別変数vに代入
NB. POSTED_NEWLINEの出現位置を求め、l に代入
l =. (POSTED_NEWLINE E. v) i. 1

NB. POSTED_NEWLINEまでの文字列を取り、残った文字列から
NB. POSTED_NEWLINEの６バイトを落とし、最初に取った文字列、CRLF、残りの文字列
NB. を連結して置換完了
(l {. v), CRLF, 6 }. l }.v
)

NB. ====================================================================================================
replace_newline_code_all =: 3 : 0
v =. y
for. (i. (+/ POSTED_NEWLINE E. y)) do.
   v =. replace_newline_code v
end.
)

NB. ====================================================================================================
NB. エスケープ文字の復元
NB. %に続く２文字はHex値なので、そのアスキー文字に変換する
decode_escaped_ascii_char =: 3 : 0
NB.一旦別変数 remainingに代入
remaining =. y
if. ((('%' E. remaining) i. 1) = ($ remaining)) do.
    decoded =. remaining
else.
  decoded =. ''
  while. ((($remaining) ~: 0) *. ((('%' E. remaining) i. 1) ~: ($ remaining))) do.

    NB. '%'、loc に代入
    loc =. ('%' E. remaining) i. 1

    NB. '%'までの文字列を取り、残った文字列から
    NB. '%'と後に続く２文字の合計３文字を取り、
    esc =: 3 {. loc }. remaining
    NB. print esc
    NB. '%'を落とす
    esc =: 1 }. esc
    NB. print esc
    NB. upper case to lower case if one of ABCDEF
    esc =: ((a. i. esc) + (32 32) * esc e. 'ABCDEF') { a.
    NB. print esc

    asciiChr =: (". ('16b', esc)) { a.

    NB. '%'を落とし、残りの２文字をhexとして、ascii 文字を決定し、最初に取った文字列、
    NB. 決まったascii文字を連結して, decodedを更新し
    NB. decodeされた３バイトを落として remainingを更新してループ実行
    decoded =. decoded, ((loc {. remaining)), asciiChr
    remaining =. 3 }. loc }.remaining
  end.
  decoded =. decoded, remaining
end.

NB. monitor result
NB. print CRLF, '【処理前】 ', y, CRLF, '【処理後】 ', decoded
    print CRLF, '[ before processing ] ', y, CRLF, '[ after  processing ] ', decoded
decoded NB. return decoded
)

NB. ====================================================================================================
NB. クライアントから送信されたフォーム部品の値(value)を取得する関数
extract_entryID_value =: 3 : 0

NB. HTMLのフォームで入力された文字列は
NB. entryID1=value1&entryID2=value2&entryID3=value3
NB. のようにentryID=valueが&で連結されたなフォーマットで送信される 
NB. 本関数は右引数にentryIDを与え、=と&で挟まれた値を抽出して返す

NB. 右引数をentryIDに代入
entryID =. y
NB. print entryID, ' in extract_entryID_value function'

NB. MSG_FROM_CLIENT内でentryIDが始まる位置のインデックスを
NB. ((entryID E. MSG_FROM_CLIENT) i. 1)で求め、
NB. その位置までの文字列を落とす
NB. ((entryID E. MSG_FROM_CLIENT) i. 1)}.MSG_FROM_CLIENT

NB. さらに、entryIDの文字数+1 (entryIDに続く=も含めて落とす為１を加算する)を
NB. 落として、valueが先頭となる文字列 value_at_top_location を求める

value_at_top_location =. (($entryID)+ 1) }. ((entryID E. MSG_FROM_CLIENT) i. 1) }. MSG_FROM_CLIENT

NB. 次に後続との区切り文字&の位置を求めて and_positionに代入する

and_position =. ('&' E. value_at_top_location) i. 1

NB. そして、その位置までの文字列を取ってentryIDのvalueとして返す
and_position {. value_at_top_location
)

NB. ====================================================================================================
position_of_str_x_in_y_str =: 4 : 0
1 + (x E. y) i. 1
)

NB. ====================================================================================================
number_of_items_separated_with_x_str_in_y_str =: 4 : 0
1 + +/ (x E. y)  NB. x x_pos_y y
)

NB. ====================================================================================================
num_of_items =: number_of_items_separated_with_x_str_in_y_str NB. short form

NB. ====================================================================================================
x_pos_y =: position_of_str_x_in_y_str  NB. short form

NB. ====================================================================================================
num_of_lines_in_y_str =: 3 : 0
CRLF num_of_items y
)

NB. ====================================================================================================
num_of_LF_lines_in_y_str =: 3 : 0
LF num_of_items y
)

NB. ====================================================================================================
num_of_items_separated_with_space_in_aLine =: 3 : 0
>: ' ' num_of_items y
)

NB. ====================================================================================================
take_LF_one_line_from_lines =: 3 : 0
(LF x_pos_y y) {. y
)

NB. ====================================================================================================
take_one_line_from_lines =: 3 : 0
(CRLF x_pos_y y) {. y
)

NB. ====================================================================================================
show_all_lines =: 3 : 0
max_lines =. num_of_lines_in_y_str y
tmp =. y
cnt =. 0
while. cnt < max_lines do.
 aPos =. CRLF x_pos_y tmp
 print aPos {. tmp
 tmp =. (aPos + 2) }. tmp
 cnt =. >: cnt
end.
)

NB. ====================================================================================================
NB. クライアントから送信されたフォーム部品(entryID)の値(value)を取得し、
NB. 部品名と抽出した値を表示する
extract_entryID_value_and_display =: 3 : 0
NB. y is entryIDを文字列で与える

NB.一旦別の変数へ格納
NB. print 'given y for etract_entryID_value_and_display ', y
v =.y

NB. 抽出した値の中の半角+文字を半角スペースに置き換え、
NB. %でエスケープされたHEX文字コードのASCII文字化を使う
NB. これでクライアントが入力したものと同一の文字列を得る

temp =. extract_entryID_value v

NB. print 'temp ', temp
temp2 =. plus_to_space_all temp
NB. print 'temp2 ', temp2
posted_value =. decode_escaped_ascii_char temp2 NB. plus_to_space_all extract_entryID_value v

NB. entryIDと抽出した値を表示する
print v, ' ==> ', posted_value

NB. 置き換え後の値を返し、J関数の引数として使う
posted_value
)

NB. ====================================================================================================
NB. HTTPのステータスラインとヘッダーフィールドを合体して返す
prepare_http_response_status_and_header_field =: 3 : 0

h1 =.  'HTTP/1.1 200 OK',CRLF
h2 =.  'Connection: keep-alive', CRLF
h3 =.  'Keep-Alive: timeout = 36000, max=0', CRLF
h4 =.  'Content-Type: text/html; charset=', ENCODING_CODE, ';', CRLF
h5 =.  'Content-Length: '

http_response_status_and_header =. h1, h2, h3, h4, h5
)

NB. ====================================================================================================
make_html_header_part =: 3 : 0
NB. まずHTMLのタイトルを設定する
    HTML_HEADER_PART =: ''
    HTML_HEADER_PART =: HTML_HEADER_PART, HTML_TAG, HEAD_TAG, TITLE_TAG

    HTML_HEADER_PART =: HTML_HEADER_PART, PAGE_TITLE
NB. HTML_HEADER_PART =: HTML_HEADER_PART, TITLE_END, HEAD_END, CRLF
    HTML_HEADER_PART =: HTML_HEADER_PART, TITLE_END, CRLF, '<style>', CRLF,'* {', CRLF, 'font-family: Courier, "MS Mincho";', CRLF,'}', CRLF, '</style>', CRLF, HEAD_END, CRLF

NB. 次にHTMLのBODYを記述
    HTML_HEADER_PART =: HTML_HEADER_PART, BODY_TAG, CRLF

    HTML_HEADER_PART =: HTML_HEADER_PART, '<hr>', PAGE_DESCRIPTION, '<hr>', CRLF

NB. HTML FORM_TAGを記述
    HTML_HEADER_PART =: HTML_HEADER_PART, FORM_TAG, CRLF

)

NB. ====================================================================================================
prepare_http_response_message_to_GET_response_image_bmp_request =: 3 : 0
h1 =.  'HTTP/1.1 200 OK',CRLF
h2 =.  'Connection: keep-alive', CRLF
h3 =.  'Keep-Alive: timeout = 36000, max=0', CRLF
h4 =.  'Content-Type: image/bmp', CRLF
NB. he =.  'Content-Encoding: base64', CRLF
a_image_file_str =. rff 'response_image.bmp'
NB. base64data =. tobase64 a_image_file_str                  NB. rff 'response_image.bmp'
NB. h5 =.  'Content-Length: ', 20j0":$base64data
h6 =.  'Contetn=Length: ', 20j0":$a_image_file_str

NB. http_response_status_and_header =. h1, h2, h3, h4, he, h5
NB. http_response_msg =. http_response_status_and_header, CRLF, CRLF, base64data

http_response_status_and_header =. h1, h2, h3, h4, h6
http_response_msg =. http_response_status_and_header, CRLF, CRLF, a_image_file_str
)

NB. ====================================================================================================
prepare_http_response_message_to_GET_response_image_png_request =: 3 : 0
h1 =.  'HTTP/1.1 200 OK',CRLF
h2 =.  'Connection: keep-alive', CRLF
h3 =.  'Keep-Alive: timeout = 36000, max=0', CRLF
h4 =.  'Content-Type: image/png', CRLF
NB. he =.  'Content-Encoding: base64', CRLF
a_image_file_str =. rff 'response_image.png'
NB. base64data =. tobase64 a_image_file_str                  NB. rff 'response_image.png'
NB. h5 =.  'Content-Length: ', 20j0":$base64data
h6 =.  'Contetn=Length: ', 20j0":$a_image_file_str

NB. http_response_status_and_header =. h1, h2, h3, h4, he, h5
NB. http_response_msg =. http_response_status_and_header, CRLF, CRLF, base64data

http_response_status_and_header =. h1, h2, h3, h4, h6
http_response_msg =. http_response_status_and_header, CRLF, CRLF, a_image_file_str
)

NB. ====================================================================================================
prepare_string_response_message_to_JCMD_method =: 3 : 0

NB. this functiion is called when server received JCMD msg
NB. prepare_string_response_message_to_JCMD_method MSG_FROM_CLIENT

arg_string =. y  NB. y is MSG_FROM_CLIENT with prefix 'JCMD' first4Char
NB. drop prefix 'JCMD' and execute the following with try. catch. end.
a_client_j_cmd =. 5}.arg_string NB. drop 'JCMD '

try.
  if. a_client_j_cmd -: 'quit' do.
    return_msg =. 'quit'
  else.
    NB. try 3!:1 for function return  NG
    NB. cmd_return =. 3!:1 a_client_j_cmd
    cmd_return =. ". a_client_j_cmd  NB. execute
    NB. もっと複雑なエラー処理が必要そう
    
    if.(":$cmd_return) -: '0 0' do.
NB.     return_msg =. '関数戻り値の　shape は 0 0 です', CRLF  NB. plot はこれで通過する
        return_msg =. 'shape of return from specified funtion is 0 0', CRLF  NB. plot はこれで通過する
     else.
        return_msg =. (":cmd_return), CRLF
     end.
    
  end.
catch.
NB.return_msg =. CRLF, '送信された　コマンド : ', CRLF, a_client_j_cmd, CRLF, 'でエラーが発生しました。', CRLF
   return_msg =. CRLF, 'your command: ', CRLF, a_client_j_cmd, CRLF, ' resulted in error', CRLF
end.

return_msg  NB. just return  i.e. echo back
)

NB. following functions are experimental

NB. ====================================================================================================
NB. integer RGB to integer BGR conversion
RGB_to_BGR =: 3 : 0
nc =. 256#. 2 1 0{ 256 256 256#: y
".10j0":nc
)

NB. ====================================================================================================
NB. ----- for opengl gl3lab image to bmp
NB. may be good for image, font seems to be no good
save_gl3lab_as_bmp_file =: 3 : 0
wd 'psel gl3lab'
glsel 'g'
box =. 0 0, glqwh''
res =. get_pixels 2 3 {box
image_dat =. (3 2{box) $ res
image_dat writebmp 'response_image.bmp'
1
)

NB. ====================================================================================================
NB. ----- for opengl gl3lab image to bmp
NB. may be good for image, font seems to be no good
save_opengl_parent_win_as_bmp_file =: 3 : 0
NB. y is parent window name ....
wd 'psel ', y
glsel 'g'
box =. 0 0, glqwh''
res =. get_pixels 2 3 {box
image_dat =. (3 2{box) $ res
image_dat writebmp 'response_image.bmp'
1
)

NB. ====================================================================================================
NB. ----- for Jturtle image in ide only j602a ---
save_current_jturtle_graph_as_bmp_file =: 3 : 0
wd 'psel graph'
glsel 'g'
box =. 0 0, glqwh''
res =. glqpixels box
image_dat =. (3 2{box) $ res
image_dat writebmp 'response_image.bmp' 
1
)

NB. ====================================================================================================
NB. ----- for Jturtle image in ide only j602a ---
save_current_jturtle_window_as_bmp_file =: 3 : 0
NB. y is parent window name
wd 'psel ', y
glsel 'g'
box =. 0 0, glqwh''
res =. glqpixels box
image_dat =. (3 2{box) $ res
image_dat writebmp 'response_image.bmp' 
1
)

NB. ====================================================================================================
NB. ----- for plot graph in ide only ---------
save_current_plot_as_bmp_file =: 3 : 0
pd 'save bmp response_image.bmp'
1
)

NB. ====================================================================================================
NB. ----- for hokusai draw only -------
NB. save current hokusai_draw to a file as bmp
NB. as response_image.bmp

save_current_hokusai_komon_img_as_bmpfile =: 3 : 0
wd 'psel ', WIN_nam
glsel 'g'
box =. 0 0, glqwh''
res =. glqpixels box
image_dat =. (3 2{box) $ res
image_dat writebmp 'response_image.bmp' 
1
)

NB. End of file
